/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.About;
import com.sap.mw.jco.JCO;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TraceWriter
implements JCO.TraceListener {
    private static final String CRLF = System.getProperty("line.separator");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int MAX_TRACE_FILE_LENGTH = 0x1400000;
    private static TraceWriter singleton = new TraceWriter();
    private String baseTraceFileName = null;
    private int fileCounter = 0;
    private File traceFile = null;
    private Writer osWriter = null;
    private DateFormat fName = new SimpleDateFormat("'JCO'yyMMdd'_'HHmmssSSS");
    private DateFormat fTime = new SimpleDateFormat("HH':'mm':'ss':'SSS");

    private TraceWriter() {
        this.osWriter = new BufferedWriter(new OutputStreamWriter(System.out));
    }

    public static TraceWriter singleton() {
        return singleton;
    }

    private void createNewFile(String fileName) {
        if (this.osWriter != null) {
            try {
                this.osWriter.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            this.traceFile = new File(fileName);
            FileOutputStream fos = new FileOutputStream(this.traceFile);
            try {
                this.osWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                new DataOutputStream(fos).write(new byte[]{-17, -69, -65}, 0, 3);
            }
            catch (UnsupportedEncodingException e) {
                this.osWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));
            }
            PrintWriter pw = new PrintWriter(this.osWriter);
            new About().printTo(pw);
            pw.println("********************  " + new Date() + "  ********************");
            if (JCO.getTraceLevel() != 0) {
                this.trace(1, "[JAV-LAYER] INFO: Current trace level is " + JCO.getTraceLevel());
            } else {
                this.osWriter.flush();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("TraceWriter.createNewFile(): cannot create trace file [" + this.traceFile.getAbsolutePath() + "]");
        }
    }

    public static String dumpContent(char[] chars) {
        return TraceWriter.dumpContent(chars, true, chars.length);
    }

    public static String dumpContent(char[] chars, boolean withHex, int lengthToDump) {
        if (chars == null) {
            chars = new char[]{};
        }
        if (lengthToDump < 0 || lengthToDump > chars.length) {
            lengthToDump = chars.length;
        }
        StringBuffer buf = new StringBuffer();
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        int i = 0;
        while (i < lengthToDump) {
            int k;
            buf.append("|");
            int k2 = 0;
            while (k2 < 8) {
                offsets[k2] = i / (int)Math.pow(10.0, k2) % 10;
                ++k2;
            }
            int k3 = 7;
            while (k3 >= 0) {
                buf.append(offsets[k3]);
                --k3;
            }
            buf.append("|");
            if (withHex) {
                k = 0;
                while (k < 20) {
                    if (i + k < chars.length) {
                        hexs[k * 4 + 0] = HEX[chars[i + k] >> 12 & 0xF];
                        hexs[k * 4 + 1] = HEX[chars[i + k] >> 8 & 0xF];
                        hexs[k * 4 + 2] = HEX[chars[i + k] >> 4 & 0xF];
                        hexs[k * 4 + 3] = HEX[chars[i + k] & 0xF];
                    } else {
                        hexs[k * 4 + 3] = 32;
                        hexs[k * 4 + 2] = 32;
                        hexs[k * 4 + 1] = 32;
                        hexs[k * 4] = 32;
                    }
                    ++k;
                }
                int k4 = 0;
                while (k4 < hexs.length) {
                    if (k4 != 0 && 0 == k4 % 20) {
                        buf.append(' ');
                    }
                    buf.append(hexs[k4]);
                    ++k4;
                }
                buf.append('|');
            }
            k = 0;
            while (k < 20) {
                char curChar = i + k < chars.length ? chars[i + k] : (char)' ';
                buf.append(!Character.isISOControl(curChar) && Character.isDefined(curChar) ? curChar : (char)'.');
                ++k;
            }
            buf.append('|');
            buf.append(CRLF);
            i += 20;
        }
        return buf.toString();
    }

    public static String dumpContent(byte[] bytes) {
        return TraceWriter.dumpContent(bytes, bytes.length);
    }

    public static String dumpContent(byte[] bytes, int lengthToDump) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (lengthToDump < 0 || lengthToDump > bytes.length) {
            lengthToDump = bytes.length;
        }
        StringBuffer buf = new StringBuffer();
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        int i = 0;
        while (i < lengthToDump) {
            buf.append("|");
            int k = 0;
            while (k < 8) {
                offsets[k] = i / (int)Math.pow(10.0, k) % 10;
                ++k;
            }
            int k2 = 7;
            while (k2 >= 0) {
                buf.append(offsets[k2]);
                --k2;
            }
            buf.append("|");
            int k3 = 0;
            while (k3 < 40) {
                if (i + k3 < bytes.length) {
                    hexs[k3 * 2 + 0] = HEX[bytes[i + k3] >> 4 & 0xF];
                    hexs[k3 * 2 + 1] = HEX[bytes[i + k3] & 0xF];
                } else {
                    hexs[k3 * 2 + 1] = 32;
                    hexs[k3 * 2] = 32;
                }
                ++k3;
            }
            int k4 = 0;
            while (k4 < hexs.length) {
                if (k4 != 0 && 0 == k4 % 20) {
                    buf.append(' ');
                }
                buf.append(hexs[k4]);
                ++k4;
            }
            buf.append('|');
            buf.append(CRLF);
            i += 40;
        }
        return buf.toString();
    }

    public void newTraceFile(String path) {
        TraceWriter traceWriter = singleton;
        synchronized (traceWriter) {
            if (path == null || path.equals("stdout")) {
                if (this.osWriter != null) {
                    try {
                        this.osWriter.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.traceFile = null;
                this.osWriter = new BufferedWriter(new OutputStreamWriter(System.out));
            } else if (path.equals("stderr")) {
                if (this.osWriter != null) {
                    try {
                        this.osWriter.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.traceFile = null;
                this.osWriter = new BufferedWriter(new OutputStreamWriter(System.err));
            } else {
                String baseFileName;
                if (!new File(path).isDirectory()) {
                    path = ".";
                }
                StringBuffer fileName = new StringBuffer(path.length() + 24);
                do {
                    fileName.setLength(0);
                    fileName.append(path);
                    fileName.append(File.separator);
                    fileName.append(this.fName.format(new Date()));
                } while ((baseFileName = fileName.toString()).equals(this.baseTraceFileName));
                this.baseTraceFileName = baseFileName;
                this.fileCounter = 0;
                fileName.append(".trc");
                this.createNewFile(fileName.toString());
            }
        }
    }

    public void trace(int messageLevel, String message) {
        try {
            TraceWriter traceWriter = singleton;
            synchronized (traceWriter) {
                if (this.traceFile != null && this.traceFile.length() > 0x1400000L) {
                    String fileName = this.baseTraceFileName + '.' + ++this.fileCounter + ".trc";
                    this.createNewFile(fileName);
                }
                this.osWriter.write(Thread.currentThread().getName());
                this.osWriter.write(" [");
                this.osWriter.write(this.fTime.format(new Date()));
                this.osWriter.write("]: ");
                this.osWriter.write(message);
                this.osWriter.write(CRLF);
                this.osWriter.flush();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("TraceWriter.trace(): " + ex.toString());
        }
    }
}

