/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleLog;

class OracleConversionInputStreamInternal
extends OracleConversionInputStream {
    boolean needReset;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStreamInternal(DBConversion conv_object, InputStream istream, int conversion, int max_bytesize) {
        block12: {
            super(conv_object, istream, conversion, max_bytesize);
            this.needReset = false;
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(max_bytesize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStreamInternal(DBConversion conv_object, Reader reader, int conversion, int max_charsize, short formOfUse) {
        block12: {
            super(conv_object, reader, conversion, max_charsize, formOfUse);
            this.needReset = false;
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(max_charsize) + ", " + OracleLog.argument(formOfUse));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] destbuf, int offset, int length) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            int ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(destbuf) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.needReset) {
                if (this.istream != null && this.istream.markSupported()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionInputStreamInternal.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "End Of Stream reached , resetting for internally created stream." + this);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.istream.reset();
                    this.endOfStream = false;
                    this.totalSize = 0;
                    this.needReset = false;
                } else if (this.reader != null && this.reader.markSupported()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionInputStreamInternal.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "End Of reader reached , resetting for internally created reader." + this);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.reader.reset();
                    this.endOfStream = false;
                    this.totalSize = 0;
                    this.needReset = false;
                }
            }
            if ((ret = super.read(destbuf, offset, length)) == -1) {
                this.needReset = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleConversionInputStreamInternal"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

