/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetCache;

class OracleResultSetCacheImpl
implements OracleResultSetCache {
    private static int DEFAULT_WIDTH = 5;
    private static int DEFAULT_SIZE = 5;
    Vector cachedRows;
    int nbOfColumnsInRow;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleResultSetCacheImpl() {
        block12: {
            this(DEFAULT_WIDTH);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleResultSetCacheImpl(int width) {
        this.cachedRows = null;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(width));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (width > 0) {
                this.nbOfColumnsInRow = width;
            }
            this.cachedRows = new Vector(DEFAULT_SIZE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int rowIndex, int columnIndex, Object columnData) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowIndex) + ", " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(columnData));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Vector cachedRow = null;
            while (this.cachedRows.size() < rowIndex) {
                cachedRow = new Vector(this.nbOfColumnsInRow);
                this.cachedRows.addElement(cachedRow);
            }
            cachedRow = (Vector)this.cachedRows.elementAt(rowIndex - 1);
            while (cachedRow.size() < columnIndex) {
                cachedRow.addElement(null);
            }
            cachedRow.setElementAt(columnData, columnIndex - 1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(int rowIndex, int columnIndex) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowIndex) + ", " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Vector row = (Vector)this.cachedRows.elementAt(rowIndex - 1);
            Object __result__ = row.elementAt(columnIndex - 1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object e2 = __result__;
            return e2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int rowIndex) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cachedRows.removeElementAt(rowIndex - 1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int rowIndex, int j2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowIndex) + ", " + OracleLog.argument(j2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cachedRows.removeElementAt(rowIndex - 1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 0;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetCacheImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleResultSetCacheImpl"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

