/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;

class PlsqlIbtBindInfo {
    Object[] arrayData;
    int maxLen;
    int curLen;
    int element_internal_type;
    int elemMaxLen;
    int ibtByteLength;
    int ibtCharLength;
    int ibtValueIndex;
    int ibtIndicatorIndex;
    int ibtLengthIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PlsqlIbtBindInfo(Object[] arrayData, int maxLen, int curLen, int element_internal_type, int elemMaxLen) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBindInfo.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(arrayData) + ", " + OracleLog.argument(maxLen) + ", " + OracleLog.argument(curLen) + ", " + OracleLog.argument(element_internal_type) + ", " + OracleLog.argument(elemMaxLen));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.arrayData = arrayData;
            this.maxLen = maxLen;
            this.curLen = curLen;
            this.element_internal_type = element_internal_type;
            switch (element_internal_type) {
                case 1: 
                case 96: {
                    this.elemMaxLen = elemMaxLen == 0 ? 2 : elemMaxLen + 1;
                    this.ibtCharLength = this.elemMaxLen * maxLen;
                    this.element_internal_type = 9;
                    return;
                }
                case 6: {
                    this.elemMaxLen = 22;
                    this.ibtByteLength = this.elemMaxLen * maxLen;
                    return;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PlsqlIbtBindInfo.logger().log(Level.SEVERE, "         Throwing SQLException: 97");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 97);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBindInfo.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PlsqlIbtBindInfo"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

