/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.oci.OracleOCIConnection;

class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T2CDriverExtension() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Connection getConnection(String url, Properties info) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(url) + ", " + OracleLog.argument(info));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            T2CConnection t2Conn = null;
            t2Conn = info.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection(url, info, (Object)this) : new T2CConnection(url, info, this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + t2Conn);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T2CConnection t2CConnection = t2Conn;
            return t2CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement allocateStatement(PhysicalConnection conn, int resultSetType, int resultSetConcurrency) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            T2CStatement __result__ = new T2CStatement((T2CConnection)conn, 1, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T2CStatement t2CStatement = __result__;
            return t2CStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            T2CPreparedStatement __result__ = new T2CPreparedStatement((T2CConnection)conn, sql, conn.defaultExecuteBatch, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T2CPreparedStatement t2CPreparedStatement = __result__;
            return t2CPreparedStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleCallableStatement allocateCallableStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            T2CCallableStatement __result__ = new T2CCallableStatement((T2CConnection)conn, sql, conn.defaultExecuteBatch, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T2CCallableStatement t2CCallableStatement = __result__;
            return t2CCallableStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleInputStream createInputStream(OracleStatement stmt, int index, Accessor accessor) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(accessor));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            T2CInputStream __result__ = new T2CInputStream(stmt, index, accessor);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T2CInputStream t2CInputStream = __result__;
            return t2CInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CDriverExtension"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

