/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CSocketInputStreamWrapper;
import oracle.jdbc.driver.T4CSocketOutputStreamWrapper;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;

class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    byte proSvrVer;
    T4CSocketInputStreamWrapper inStream;
    T4CSocketOutputStreamWrapper outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final int[] retLen = new int[1];
    AtomicReference<OracleConnection> connForException = new AtomicReference();
    ArrayList refVector = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    static String toHex(long value, int bytes) {
        String result;
        switch (bytes) {
            case 1: {
                result = "00" + Long.toString(value & 0xFFL, 16);
                break;
            }
            case 2: {
                result = "0000" + Long.toString(value & 0xFFFFL, 16);
                break;
            }
            case 3: {
                result = "000000" + Long.toString(value & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                result = "00000000" + Long.toString(value & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                result = "0000000000" + Long.toString(value & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                result = "000000000000" + Long.toString(value & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                result = "00000000000000" + Long.toString(value & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return T4CMAREngine.toHex(value >> 32, 4) + T4CMAREngine.toHex(value, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + result.substring(result.length() - 2 * bytes);
    }

    static String toHex(byte value) {
        String result = "00" + Integer.toHexString(value & 0xFF);
        return "0x" + result.substring(result.length() - 2);
    }

    static String toHex(short value) {
        return T4CMAREngine.toHex(value, 2);
    }

    static String toHex(int value) {
        return T4CMAREngine.toHex(value, 4);
    }

    static String toHex(byte[] value, int length) {
        if (value == null) {
            return "null";
        }
        if (length > value.length) {
            return "byte array not long enough";
        }
        String result = "[";
        int len = Math.min(64, length);
        for (int i2 = 0; i2 < len; ++i2) {
            result = result + T4CMAREngine.toHex(value[i2]) + " ";
        }
        if (len < length) {
            result = result + "...";
        }
        return result + "]";
    }

    static String toHex(byte[] value) {
        if (value == null) {
            return "null";
        }
        return T4CMAREngine.toHex(value, value.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CMAREngine(Communication net) throws SQLException, IOException {
        if (net == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 433);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.net = net;
        try {
            this.outStream = new T4CSocketOutputStreamWrapper((NetOutputStream)net.getOutputStream());
            this.inStream = new T4CSocketInputStreamWrapper((NetInputStream)net.getInputStream(), this.outStream);
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        this.types = new T4CTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    void initBuffers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalSB1(byte value) throws IOException {
        this.outStream.write(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalUB1(short value) throws IOException {
        this.outStream.write((byte)(value & 0xFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalSB2(short value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer2, (byte)1);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer2, 0, bytes);
        }
    }

    final void marshalUB2(int value) throws IOException {
        this.marshalSB2((short)(value & 0xFFFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalSB4(int value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer4, (byte)2);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer4, 0, bytes);
        }
    }

    final void marshalUB4(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalSB8(long value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer8, (byte)3);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer8, 0, bytes);
        }
    }

    final void marshalSWORD(int value) throws IOException {
        this.marshalSB4(value);
    }

    final void marshalUWORD(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalB1Array(byte[] value) throws IOException {
        if (value.length > 0) {
            this.outStream.write(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalB1Array(byte[] value, int off, int len) throws IOException {
        if (value.length > 0) {
            this.outStream.write(value, off, len);
        }
    }

    final void marshalUB4Array(long[] value) throws IOException {
        for (int i2 = 0; i2 < value.length; ++i2) {
            this.marshalSB4((int)(value[i2] & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    final void marshalO2U(boolean notnull) throws IOException {
        if (notnull) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    final void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    final void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    final void marshalCHR(byte[] value) throws IOException {
        this.marshalCHR(value, 0, value.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalCHR(byte[] value, int offset, int length) throws IOException {
        if (length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(value, offset, length);
            } else {
                this.outStream.write(value, offset, length);
            }
        }
    }

    final void marshalCLR(byte[] value, int valueLen) throws IOException {
        this.marshalCLR(value, 0, valueLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalCLR(byte[] value, int offset, int valueLen) throws IOException {
        if (valueLen > 64) {
            int len;
            int nbBytesWritten = 0;
            this.outStream.write(-2);
            do {
                int bytesLeft;
                len = (bytesLeft = valueLen - nbBytesWritten) > 64 ? 64 : bytesLeft;
                this.outStream.write((byte)(len & 0xFF));
                this.outStream.write(value, offset + nbBytesWritten, len);
            } while ((nbBytesWritten += len) < valueLen);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(valueLen & 0xFF));
            if (value.length != 0) {
                this.outStream.write(value, offset, valueLen);
            }
        }
    }

    final void marshalKEYVAL(byte[][] keys, int[] keysSize, byte[][] values, int[] valuesSize, byte[] kvalflg, int nb) throws IOException {
        for (int i2 = 0; i2 < nb; ++i2) {
            if (keys[i2] != null && keysSize[i2] > 0) {
                this.marshalUB4(keysSize[i2]);
                this.marshalCLR(keys[i2], 0, keysSize[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (values[i2] != null && valuesSize[i2] > 0) {
                this.marshalUB4(valuesSize[i2]);
                this.marshalCLR(values[i2], 0, valuesSize[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (kvalflg[i2] != 0) {
                this.marshalUB4(1L);
                continue;
            }
            this.marshalUB4(0L);
        }
    }

    final void marshalKEYVAL(byte[][] keys, byte[][] values, byte[] kvalflg, int nb) throws IOException {
        int[] keysSize = new int[nb];
        int[] valuesSize = new int[nb];
        for (int i2 = 0; i2 < nb; ++i2) {
            if (keys[i2] != null) {
                keysSize[i2] = keys[i2].length;
            }
            if (values[i2] == null) continue;
            valuesSize[i2] = values[i2].length;
        }
        this.marshalKEYVAL(keys, keysSize, values, valuesSize, kvalflg, nb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalDALC(byte[] buffer) throws IOException {
        if (buffer == null || buffer.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & buffer.length);
            this.marshalCLR(buffer, buffer.length);
        }
    }

    final void marshalKPDKV(byte[][] textValues, byte[][] binaryValues, int[] keywords) throws IOException {
        for (int i2 = 0; i2 < textValues.length; ++i2) {
            if (textValues[i2] != null) {
                this.marshalUB4(textValues[i2].length);
                this.marshalCLR(textValues[i2], 0, textValues[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            if (binaryValues[i2] != null) {
                this.marshalUB4(binaryValues[i2].length);
                this.marshalCLR(binaryValues[i2], 0, binaryValues[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            this.marshalUB2(keywords[i2]);
        }
    }

    final void unmarshalKPDKV(byte[][] textValues, int[] textValuesLength, byte[][] binaryValues, int[] keywords) throws IOException, SQLException {
        int tempLength = 0;
        int[] tempAr = new int[1];
        for (int i2 = 0; i2 < textValues.length; ++i2) {
            tempLength = (int)this.unmarshalUB4();
            if (tempLength > 0) {
                textValues[i2] = new byte[tempLength];
                this.unmarshalCLR(textValues[i2], 0, tempAr, tempLength);
                textValuesLength[i2] = tempAr[0];
            }
            if ((tempLength = (int)this.unmarshalUB4()) > 0) {
                binaryValues[i2] = new byte[tempLength];
                this.unmarshalCLR(binaryValues[i2], 0, tempAr, tempLength);
            }
            keywords[i2] = this.unmarshalUB2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addPtr(byte value) throws IOException {
        if ((this.types.rep[4] & 1) > 0) {
            this.outStream.write(value);
        } else {
            byte bytes = this.value2Buffer(value, this.tmpBuffer4, (byte)4);
            if (bytes != 0) {
                this.outStream.write(this.tmpBuffer4, 0, bytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte value2Buffer(int value, byte[] outBuffer, byte repOffset) throws IOException {
        boolean isUniversal = (this.types.rep[repOffset] & 1) > 0;
        boolean zeros = true;
        byte bytes = 0;
        for (int i2 = outBuffer.length - 1; i2 >= 0; --i2) {
            outBuffer[bytes] = (byte)(value >>> 8 * i2 & 0xFF);
            if (isUniversal) {
                if (zeros && outBuffer[bytes] == 0) continue;
                zeros = false;
                bytes = (byte)(bytes + 1);
                continue;
            }
            bytes = (byte)(bytes + 1);
        }
        if (isUniversal) {
            this.outStream.write(bytes);
        }
        if ((this.types.rep[repOffset] & 2) > 0) {
            this.reverseArray(outBuffer, bytes);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte value2Buffer(long value, byte[] outBuffer, byte repOffset) throws IOException {
        boolean isUniversal = (this.types.rep[repOffset] & 1) > 0;
        boolean zeros = true;
        byte bytes = 0;
        for (int i2 = outBuffer.length - 1; i2 >= 0; --i2) {
            outBuffer[bytes] = (byte)(value >>> 8 * i2 & 0xFFL);
            if (isUniversal) {
                if (zeros && outBuffer[bytes] == 0) continue;
                zeros = false;
                bytes = (byte)(bytes + 1);
                continue;
            }
            bytes = (byte)(bytes + 1);
        }
        if (isUniversal) {
            this.outStream.write(bytes);
        }
        if ((this.types.rep[repOffset] & 2) > 0) {
            this.reverseArray(outBuffer, bytes);
        }
        return bytes;
    }

    final void reverseArray(byte[] buffer, byte bytes) {
        int mid = bytes / 2;
        for (int i2 = 0; i2 < mid; ++i2) {
            byte tmp = buffer[i2];
            buffer[i2] = buffer[bytes - 1 - i2];
            buffer[bytes - 1 - i2] = tmp;
        }
    }

    final byte unmarshalSB1() throws SQLException, IOException {
        byte result = (byte)this.unmarshalUB1();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final short unmarshalUB1() throws SQLException, IOException {
        short value = 0;
        try {
            value = (short)this.inStream.read();
        }
        catch (BreakNetException e2) {
            this.net.sendReset();
            throw e2;
        }
        if (value < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 410);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return value;
    }

    final short unmarshalSB2() throws SQLException, IOException {
        short result = (short)this.unmarshalUB2();
        return result;
    }

    final int unmarshalUB2() throws SQLException, IOException {
        int value = (int)this.buffer2Value((byte)1);
        return value & 0xFFFF;
    }

    final int unmarshalUCS2(byte[] ucs2Char, long offset) throws SQLException, IOException {
        int value = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((value & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(value & 0xFF);
        if (offset + 1L < (long)ucs2Char.length) {
            ucs2Char[(int)offset] = this.tmpBuffer2[0];
            ucs2Char[(int)offset + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    final int unmarshalSB4() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    final long unmarshalUB4() throws SQLException, IOException {
        long value = this.buffer2Value((byte)2);
        return value;
    }

    final int unmarshalSB4(byte[] buffer) throws SQLException, IOException {
        long value = this.buffer2Value((byte)2, new ByteArrayInputStream(buffer));
        return (int)value;
    }

    final long unmarshalSB8() throws SQLException, IOException {
        long value = this.buffer2Value((byte)3);
        return value;
    }

    final int unmarshalRefCursor(byte[] buffer) throws SQLException, IOException {
        int result = this.unmarshalSB4(buffer);
        return result;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long result = this.unmarshalUB4();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] tmpBuffer;
        block9: {
            tmpBuffer = new byte[n2];
            if (n2 > 0) {
                try {
                    if (this.inStream.read(tmpBuffer) >= 0) break block9;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 410);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (BreakNetException e2) {
                    this.net.sendReset();
                    throw e2;
                }
            }
        }
        return tmpBuffer;
    }

    int unmarshalNBytes(byte[] buf, int off, int n2) throws SQLException, IOException {
        int bytes;
        for (bytes = 0; bytes < n2; bytes += this.getNBytes(buf, off + bytes, n2 - bytes)) {
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNBytes(byte[] buf, int off, int len) throws SQLException, IOException {
        int cnt;
        block8: {
            cnt = 0;
            try {
                cnt = this.inStream.read(buf, off, len);
                if (cnt >= 0) break block8;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 410);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (BreakNetException e2) {
                this.net.sendReset();
                throw e2;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] tmpBuffer;
        block8: {
            tmpBuffer = new byte[n2];
            try {
                if (this.inStream.read(tmpBuffer) >= 0) break block8;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 410);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (BreakNetException e2) {
                this.net.sendReset();
                throw e2;
            }
        }
        return tmpBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] unmarshalTEXT(int bytes) throws SQLException, IOException {
        byte[] buffer;
        int offset = 0;
        byte[] tmpBuffer = new byte[bytes];
        while (offset < bytes) {
            block11: {
                try {
                    if (this.inStream.read(tmpBuffer, offset, 1) >= 0) break block11;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 410);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (BreakNetException e2) {
                    this.net.sendReset();
                    throw e2;
                }
            }
            if (tmpBuffer[offset++] != 0) continue;
        }
        if (tmpBuffer.length == --offset) {
            buffer = tmpBuffer;
        } else {
            buffer = new byte[offset];
            System.arraycopy(tmpBuffer, 0, buffer, 0, offset);
        }
        return buffer;
    }

    byte[] unmarshalCHR(int retLength) throws SQLException, IOException {
        byte[] resBuffer = null;
        if (this.types.isConvNeeded()) {
            resBuffer = this.unmarshalCLR(retLength, this.retLen);
            if (resBuffer.length != this.retLen[0]) {
                byte[] tmpBuf = new byte[this.retLen[0]];
                System.arraycopy(resBuffer, 0, tmpBuf, 0, this.retLen[0]);
                resBuffer = tmpBuf;
            }
        } else {
            resBuffer = this.getNBytes(retLength);
        }
        return resBuffer;
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray) throws SQLException, IOException {
        this.unmarshalCLR(bytes, offsetRow, intArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray, int maxSize) throws SQLException, IOException {
        this.unmarshalCLR(bytes, offsetRow, intArray, maxSize, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray, int maxSize, int ignoreNBytes) throws SQLException, IOException {
        int nbBytesWritten;
        int offset;
        block28: {
            int lastread;
            int nbOfBytesIgnored;
            int keepThem;
            boolean optimized;
            int locallen;
            int len;
            block27: {
                len = 0;
                locallen = 0;
                offset = offsetRow;
                optimized = false;
                nbBytesWritten = 0;
                keepThem = 0;
                nbOfBytesIgnored = 0;
                lastread = -1;
                len = this.unmarshalUB1();
                if (len < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (len == 0) {
                    intArray[0] = 0;
                    return;
                }
                if (this.escapeSequenceNull(len)) {
                    intArray[0] = 0;
                    return;
                }
                if (len == 254) break block27;
                if (ignoreNBytes - nbOfBytesIgnored >= len) {
                    this.unmarshalBuffer(this.ignored, 0, len);
                    nbOfBytesIgnored += len;
                    len = 0;
                } else if (ignoreNBytes - nbOfBytesIgnored > 0) {
                    this.unmarshalBuffer(this.ignored, 0, ignoreNBytes - nbOfBytesIgnored);
                    len -= ignoreNBytes - nbOfBytesIgnored;
                    nbOfBytesIgnored += ignoreNBytes - nbOfBytesIgnored;
                }
                if (len <= 0) break block28;
                keepThem = Math.min(maxSize - nbBytesWritten, len);
                offset = this.unmarshalBuffer(bytes, offset, keepThem);
                nbBytesWritten += keepThem;
                int rest = len - keepThem;
                if (rest <= 0) break block28;
                this.unmarshalBuffer(this.ignored, 0, rest);
                break block28;
            }
            lastread = -1;
            block8: while (lastread == -1 || (len = this.unmarshalUB1()) > 0) {
                if (len == 254) {
                    switch (lastread) {
                        case -1: {
                            lastread = 1;
                            continue block8;
                        }
                        case 1: {
                            lastread = 0;
                            break;
                        }
                        case 0: {
                            if (optimized) {
                                lastread = 0;
                                break;
                            }
                            lastread = 0;
                            continue block8;
                        }
                    }
                }
                if (offset == -1) {
                    this.unmarshalBuffer(this.ignored, 0, len);
                } else {
                    locallen = len;
                    if (ignoreNBytes - nbOfBytesIgnored >= locallen) {
                        this.unmarshalBuffer(this.ignored, 0, locallen);
                        nbOfBytesIgnored += locallen;
                        locallen = 0;
                    } else if (ignoreNBytes - nbOfBytesIgnored > 0) {
                        this.unmarshalBuffer(this.ignored, 0, ignoreNBytes - nbOfBytesIgnored);
                        locallen -= ignoreNBytes - nbOfBytesIgnored;
                        nbOfBytesIgnored += ignoreNBytes - nbOfBytesIgnored;
                    }
                    if (locallen > 0) {
                        keepThem = Math.min(maxSize - nbBytesWritten, locallen);
                        offset = this.unmarshalBuffer(bytes, offset, keepThem);
                        nbBytesWritten += keepThem;
                        int rest = locallen - keepThem;
                        if (rest > 0) {
                            this.unmarshalBuffer(this.ignored, 0, rest);
                        }
                    }
                }
                lastread = 0;
                if (len <= 252) continue;
                optimized = true;
            }
        }
        if (intArray != null) {
            intArray[0] = offset != -1 ? nbBytesWritten : bytes.length - offsetRow;
        }
    }

    final byte[] unmarshalCLR(int buflen, int[] intArray) throws SQLException, IOException {
        byte[] tmpBuf = new byte[buflen * this.conv.c2sNlsRatio];
        this.unmarshalCLR(tmpBuf, 0, intArray, buflen);
        return tmpBuf;
    }

    final int[] unmarshalKEYVAL(byte[][] keys, byte[][] values, int nb) throws SQLException, IOException {
        byte[] buff = new byte[1000];
        int[] length = new int[1];
        int[] kvalflg = new int[nb];
        for (int i2 = 0; i2 < nb; ++i2) {
            int len = this.unmarshalSB4();
            if (len > 0) {
                this.unmarshalCLR(buff, 0, length);
                keys[i2] = new byte[length[0]];
                System.arraycopy(buff, 0, keys[i2], 0, length[0]);
            }
            if ((len = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(buff, 0, length);
                values[i2] = new byte[length[0]];
                System.arraycopy(buff, 0, values[i2], 0, length[0]);
            }
            kvalflg[i2] = this.unmarshalSB4();
        }
        buff = null;
        return kvalflg;
    }

    final int unmarshalBuffer(byte[] _byteValue, int offset, int len) throws SQLException, IOException {
        if (len <= 0) {
            return offset;
        }
        if (_byteValue.length < offset + len) {
            this.unmarshalNBytes(_byteValue, offset, _byteValue.length - offset);
            this.unmarshalNBytes(this.ignored, 0, offset + len - _byteValue.length);
            offset = -1;
        } else {
            this.unmarshalNBytes(_byteValue, offset, len);
            offset += len;
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short len = 0;
        short totalLen = 0;
        byte[] finalBuffer = null;
        short bytes = this.unmarshalUB1();
        if (bytes < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (bytes == 0) {
            return null;
        }
        boolean isEscapeSequenceNull = this.escapeSequenceNull(bytes);
        if (!isEscapeSequenceNull) {
            if (this.refVector == null) {
                this.refVector = new ArrayList(10);
            } else {
                this.refVector.clear();
            }
        }
        if (!isEscapeSequenceNull) {
            byte[] tmpBuf;
            if (bytes == 254) {
                while ((len = this.unmarshalUB1()) > 0) {
                    if (len == 254 && this.types.isServerConversion()) continue;
                    totalLen = (short)(totalLen + len);
                    tmpBuf = new byte[len];
                    this.unmarshalBuffer(tmpBuf, 0, len);
                    this.refVector.add(tmpBuf);
                }
            } else {
                totalLen = bytes;
                tmpBuf = new byte[bytes];
                this.unmarshalBuffer(tmpBuf, 0, bytes);
                this.refVector.add(tmpBuf);
            }
            finalBuffer = new byte[totalLen];
            int start = 0;
            while (this.refVector.size() > 0) {
                int arrayLen = ((byte[])this.refVector.get(0)).length;
                System.arraycopy(this.refVector.get(0), 0, finalBuffer, start, arrayLen);
                start += arrayLen;
                this.refVector.remove(0);
            }
        } else {
            finalBuffer = null;
        }
        return finalBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean escapeSequenceNull(int bytes) throws SQLException {
        boolean is_null = false;
        switch (bytes) {
            case 0: {
                is_null = true;
                break;
            }
            case 253: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            case 255: {
                is_null = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return is_null;
    }

    final int processIndicator(boolean isNull, int dataSize) throws SQLException, IOException {
        short ind = this.unmarshalSB2();
        int res = 0;
        if (!isNull) {
            res = ind == 0 ? dataSize : (ind == -2 || ind > 0 ? (int)ind : 65536 + ind);
        }
        return res;
    }

    final long unmarshalDALC(byte[] buffer, int offset, int[] returnLength) throws SQLException, IOException {
        long len = this.unmarshalUB4();
        if (len > 0L) {
            this.unmarshalCLR(buffer, offset, returnLength);
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte[] unmarshalDALC() throws SQLException, IOException {
        long len = this.unmarshalUB4();
        byte[] buffer = new byte[(int)(0xFFFFFFFFFFFFFFFFL & len)];
        if (buffer.length > 0) {
            if ((buffer = this.unmarshalCLR(buffer.length, this.retLen)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        } else {
            buffer = new byte[]{};
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte[] unmarshalDALC(int[] CLRRetLen) throws SQLException, IOException {
        long len = this.unmarshalUB4();
        byte[] buffer = new byte[(int)(0xFFFFFFFFFFFFFFFFL & len)];
        if (buffer.length > 0) {
            if ((buffer = this.unmarshalCLR(buffer.length, CLRRetLen)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        } else {
            buffer = new byte[]{};
        }
        return buffer;
    }

    final long buffer2Value(byte repOffset) throws SQLException, IOException {
        long returnValue = 0L;
        int bufLength = 1;
        if ((this.types.rep[repOffset] & 1) > 0) {
            bufLength = this.inStream.readB1();
        } else {
            switch (repOffset) {
                case 1: {
                    bufLength = 2;
                    break;
                }
                case 2: {
                    bufLength = 4;
                    break;
                }
                case 3: {
                    bufLength = 8;
                }
            }
        }
        returnValue = (this.types.rep[repOffset] & 2) > 0 ? this.inStream.readLongLSB(bufLength) : this.inStream.readLongMSB(bufLength);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long buffer2Value(byte repOffset, ByteArrayInputStream in) throws SQLException, IOException {
        byte[] tmpBuffer;
        int bufLength = 0;
        long value = 0L;
        boolean negative = false;
        if ((this.types.rep[repOffset] & 1) > 0) {
            bufLength = in.read();
            if ((bufLength & 0x80) > 0) {
                bufLength &= 0x7F;
                negative = true;
            }
            if (bufLength < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 410);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (bufLength == 0) {
                return 0L;
            }
            if (repOffset == 1 && bufLength > 2 || repOffset == 2 && bufLength > 4) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 412);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 412);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        } else if (repOffset == 1) {
            bufLength = 2;
        } else if (repOffset == 2) {
            bufLength = 4;
        }
        if (in.read(tmpBuffer = new byte[bufLength]) < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 410);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        for (int i2 = 0; i2 < tmpBuffer.length; ++i2) {
            short tmpByte = (this.types.rep[repOffset] & 2) > 0 ? (short)(tmpBuffer[tmpBuffer.length - 1 - i2] & 0xFF) : (short)(tmpBuffer[i2] & 0xFF);
            value |= (long)(tmpByte << 8 * (tmpBuffer.length - 1 - i2));
        }
        value &= 0xFFFFFFFFFFFFFFFFL;
        if (negative) {
            value = -value;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connForException.get());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = this.connForException.get();
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionDuringExceptionHandling(OracleConnection conn) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.connForException.set(conn);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CMAREngine.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CMAREngine"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

