/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.XSAttributeI;
import oracle.jdbc.internal.XSAttribute;
import oracle.jdbc.internal.XSNamespace;
import oracle.sql.TIMESTAMPTZ;

class XSNamespaceI
extends XSNamespace {
    String namespaceName = null;
    byte[] namespaceNameBytes;
    XSAttributeI[] attributes = null;
    byte[] timestampBytes = null;
    long flag = 0L;
    byte[][] aclList = null;

    XSNamespaceI() {
    }

    @Override
    public void setNamespaceName(String _namespaceName) throws SQLException {
        this.namespaceName = _namespaceName;
    }

    @Override
    public void setTimestamp(TIMESTAMPTZ _timestamp) throws SQLException {
        this.timestampBytes = _timestamp.toBytes();
    }

    private void setTimestamp(byte[] _timestamp) throws SQLException {
        this.timestampBytes = _timestamp;
    }

    @Override
    public void setACLIdList(byte[][] _aclList) throws SQLException {
        this.aclList = _aclList;
    }

    @Override
    public void setFlag(long _flag) throws SQLException {
        this.flag = _flag;
    }

    @Override
    public void setAttributes(XSAttribute[] _attributes) throws SQLException {
        if (_attributes != null) {
            XSAttributeI[] _attr = new XSAttributeI[_attributes.length];
            for (int i2 = 0; i2 < _attributes.length; ++i2) {
                _attr[i2] = (XSAttributeI)_attributes[i2];
            }
            this.attributes = _attr;
        }
    }

    void doCharConversion(DBConversion conv) throws SQLException {
        this.namespaceNameBytes = (byte[])(this.namespaceName != null ? conv.StringToCharBytes(this.namespaceName) : null);
        if (this.attributes != null) {
            for (int i2 = 0; i2 < this.attributes.length; ++i2) {
                this.attributes[i2].doCharConversion(conv);
            }
        }
    }

    @Override
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @Override
    public TIMESTAMPTZ getTimestamp() {
        return new TIMESTAMPTZ(this.timestampBytes);
    }

    @Override
    public long getFlag() {
        return this.flag;
    }

    @Override
    public XSAttribute[] getAttributes() {
        return this.attributes;
    }

    @Override
    public byte[][] getACLIdList() {
        return this.aclList;
    }

    void marshal(T4CMAREngine mar) throws IOException {
        if (this.namespaceNameBytes != null) {
            mar.marshalUB4(this.namespaceNameBytes.length);
            mar.marshalCLR(this.namespaceNameBytes, this.namespaceNameBytes.length);
        } else {
            mar.marshalUB4(0L);
        }
        if (this.timestampBytes != null) {
            mar.marshalUB4(this.timestampBytes.length);
            mar.marshalCLR(this.timestampBytes, this.timestampBytes.length);
        } else {
            mar.marshalUB4(0L);
        }
        mar.marshalUB4(this.flag);
        if (this.attributes != null) {
            mar.marshalUB4(this.attributes.length);
            mar.marshalUB1((short)28);
            for (int i2 = 0; i2 < this.attributes.length; ++i2) {
                this.attributes[i2].marshal(mar);
            }
        } else {
            mar.marshalUB4(0L);
        }
        if (this.aclList != null) {
            byte[] acls = new byte[this.aclList.length * 16];
            for (int i3 = 0; i3 < this.aclList.length; ++i3) {
                System.arraycopy(this.aclList[i3], 0, acls, 16 * i3, 16);
            }
            mar.marshalUB4(acls.length);
            mar.marshalCLR(acls, acls.length);
        } else {
            mar.marshalUB4(0L);
        }
    }

    static XSNamespaceI unmarshal(T4CMAREngine mar) throws SQLException, IOException {
        int[] intArr = new int[1];
        String namespaceName = null;
        int namespaceNameLength = (int)mar.unmarshalUB4();
        if (namespaceNameLength > 0) {
            byte[] namespaceNameBytesTemp = new byte[namespaceNameLength];
            mar.unmarshalCLR(namespaceNameBytesTemp, 0, intArr);
            namespaceName = mar.conv.CharBytesToString(namespaceNameBytesTemp, intArr[0]);
        }
        byte[] timestampBytes = null;
        int timestampLength = (int)mar.unmarshalUB4();
        if (timestampLength > 0) {
            timestampBytes = mar.unmarshalNBytes(timestampLength);
        }
        long flag = mar.unmarshalUB4();
        XSAttribute[] attributes = null;
        int nbOfAttr = (int)mar.unmarshalUB4();
        attributes = new XSAttribute[nbOfAttr];
        if (nbOfAttr > 0) {
            mar.unmarshalUB1();
        }
        for (int i2 = 0; i2 < nbOfAttr; ++i2) {
            attributes[i2] = XSAttributeI.unmarshal(mar);
        }
        int aclListLength = (int)mar.unmarshalUB4();
        Object aclList = null;
        if (aclListLength > 0) {
            byte[] acls = new byte[aclListLength];
            mar.unmarshalCLR(acls, 0, intArr);
            int nbOfACLId = aclListLength / 16;
            aclList = new byte[nbOfACLId][];
            for (int i3 = 0; i3 < nbOfACLId; ++i3) {
                aclList[i3] = new byte[16];
                System.arraycopy(acls, i3 * 16, aclList[i3], 0, 16);
            }
        }
        XSNamespaceI namespace = new XSNamespaceI();
        namespace.setNamespaceName(namespaceName);
        namespace.setTimestamp(timestampBytes);
        namespace.setFlag(flag);
        namespace.setAttributes(attributes);
        namespace.setACLIdList((byte[][])aclList);
        return namespace;
    }
}

