/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class Util {
    private static int[] ldsRoundTable = new int[]{0, 1, 0, 2, 0, 0, 0, 3, 0};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkNextByte(InputStream in, byte value) throws SQLException {
        block24: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(in) + ", " + OracleLog.argument(value));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    if (in.read() == value) break block24;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            Util.logger().log(Level.SEVERE, "         Throwing SQLException: 47parseTDS");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 47, "parseTDS");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (IOException ex) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] toJavaUnsignedBytes(byte[] array) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(array));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int[] result = new int[array.length];
            for (int i2 = 0; i2 < array.length; ++i2) {
                result[i2] = array[i2] & 0xFF;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readBytes(InputStream in, int length) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] array;
            block31: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(in) + ", " + OracleLog.argument(length));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                array = new byte[length];
                try {
                    int length_read = in.read(array);
                    if (length_read == length) break block31;
                    byte[] final_bytes = new byte[length_read];
                    System.arraycopy(array, 0, final_bytes, 0, length_read);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            Util.logger().log(OracleLog.TRACE_30, "         Return: " + final_bytes);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    byte[] byArray = final_bytes;
                    return byArray;
                }
                catch (IOException ex) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + array);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = array;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBytes(OutputStream out, byte[] array) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(out) + ", " + OracleLog.argument(array));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                out.write(array);
            }
            catch (IOException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void skipBytes(InputStream in, int byte_num) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(in) + ", " + OracleLog.argument(byte_num));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                in.skip(byte_num);
            }
            catch (IOException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readLong(InputStream in) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(in));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] bytes = new byte[4];
            try {
                in.read(bytes);
                long __result__ = (((bytes[0] & 0xFF) * 256 + (bytes[1] & 0xFF)) * 256 + (bytes[2] & 0xFF)) * 256 + (bytes[3] & 0xFF);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l2 = __result__;
                return l2;
            }
            catch (IOException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short readShort(InputStream in) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(in));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] bytes = new byte[2];
            try {
                in.read(bytes);
                short __result__ = (short)((bytes[0] & 0xFF) * 256 + (bytes[1] & 0xFF));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                short s2 = __result__;
                return s2;
            }
            catch (IOException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte readByte(InputStream in) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(in));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                byte __result__ = (byte)in.read();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by = __result__;
                return by;
            }
            catch (IOException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte fdoGetSize(byte[] FDO, int mapping_offset) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(FDO) + ", " + OracleLog.argument(mapping_offset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte value = Util.fdoGetEntry(FDO, mapping_offset);
            byte __result__ = (byte)(value >> 3 & 0x1F);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte fdoGetAlign(byte[] FDO, int mapping_offset) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(FDO) + ", " + OracleLog.argument(mapping_offset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte value = Util.fdoGetEntry(FDO, mapping_offset);
            byte __result__ = (byte)(value & 7);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int ldsRound(int size, int alignvalue) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(size) + ", " + OracleLog.argument(alignvalue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int sval = ldsRoundTable[alignvalue];
            int __result__ = (size >> sval) + 1 << sval;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte fdoGetEntry(byte[] FDO, int mapping_offset) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(FDO) + ", " + OracleLog.argument(mapping_offset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            short fdo_5 = Util.getUnsignedByte(FDO[5]);
            byte value = FDO[6 + fdo_5 + mapping_offset];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + value);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = value;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getUnsignedByte(byte b2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(b2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            short __result__ = (short)(b2 & 0xFF);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeObject(Object obj) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(obj));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (obj == null) {
                byte[] __result__ = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = __result__;
                return byArray;
            }
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream p2 = new ObjectOutputStream(ostream);
            p2.writeObject(obj);
            p2.flush();
            byte[] __result__ = ostream.toByteArray();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (bytes == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(OracleLog.TRACE_30, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object var3_3 = null;
                return var3_3;
            }
            ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
            Object __result__ = new ObjectInputStream(istream).readObject();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = __result__;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static void printByteArray(byte[] x) {
        System.out.println("DONT CALL THIS -- oracle.jdbc.oracore.Util.printByteArray");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.Util"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

