/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;

class OracleFailoverEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleFailoverEventHandlerThread() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFailoverEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFailoverEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFailoverEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Subscriber sub = null;
            String eventStr = "(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")";
            while (this.cacheManager.failoverEnabledCacheExists()) {
                block37: {
                    block36: {
                        try {
                            sub = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Object run() {
                                    try {
                                        return new Subscriber("(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")", "", 30000L);
                                    }
                                    catch (SubscriptionException e2) {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleFailoverEventHandlerThread.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + e2.getMessage());
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                        }
                                        return null;
                                    }
                                }
                            });
                        }
                        catch (PrivilegedActionException e2) {
                            if (!TRACE || !OracleLog.recursiveEnter()) break block36;
                            try {
                                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleFailoverEventHandlerThread.run()- " + "PrivilegedActionException: " + e2.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                    if (sub != null) {
                        try {
                            while (this.cacheManager.failoverEnabledCacheExists()) {
                                this.event = sub.receive(true);
                                if (this.event == null) continue;
                                this.handleEvent(this.event);
                            }
                        }
                        catch (ONSException e3) {
                            sub.close();
                            if (!TRACE || !OracleLog.recursiveEnter()) break block37;
                            try {
                                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleFailoverEventHandlerThread.run() - " + "ONS Exception :" + e3.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ea) {
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleFailoverEventHandlerThread.run()-" + " Got an InterruptedException:" + ea.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFailoverEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFailoverEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEvent(Notification event) {
        block23: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFailoverEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(event));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    int eventType = 0;
                    if (event.type().equalsIgnoreCase("database/event/service")) {
                        eventType = 256;
                    } else if (event.type().equalsIgnoreCase("database/event/host")) {
                        eventType = 512;
                    }
                    if (eventType != 0) {
                        this.cacheManager.verifyAndHandleEvent(eventType, event.body());
                    }
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block23;
                    try {
                        OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleFailoverEventHandlerThread.handleEvent()" + " - SQLException:" + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFailoverEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleFailoverEventHandlerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

