/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

class OracleFailoverWorkerThread
extends Thread {
    protected OracleImplicitConnectionCache implicitCache = null;
    protected int eventType = 0;
    protected String eventServiceName = null;
    protected String instanceNameKey = null;
    protected String databaseNameKey = null;
    protected String hostNameKey = null;
    protected String status = null;
    protected int cardinality = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleFailoverWorkerThread(OracleImplicitConnectionCache oicc, int eventType, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oicc) + ", " + OracleLog.argument(eventType) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status) + ", " + OracleLog.argument(card));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.implicitCache = oicc;
            this.eventType = eventType;
            this.instanceNameKey = instNameKey;
            this.databaseNameKey = dbUniqNameKey;
            this.hostNameKey = hostNameKey;
            this.status = status;
            this.cardinality = card;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    if (this.status != null) {
                        this.implicitCache.processFailoverEvent(this.eventType, this.instanceNameKey, this.databaseNameKey, this.hostNameKey, this.status, this.cardinality);
                    }
                }
                catch (Exception ex) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block20;
                    try {
                        OracleFailoverWorkerThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.OracleFailoverWorkerThread()" + "\neventType=" + this.eventType + "\ninstanceName=" + this.instanceNameKey + "\ndatabaseName=" + this.databaseNameKey + "\nhostName=" + this.hostNameKey + "\nstatus=" + this.status + "\ncardinality=" + this.cardinality + "\n" + ex.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleFailoverWorkerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

