/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class OracleXAException
extends XAException {
    private int xaError = 0;
    private int primary = 0;
    private int secondary = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleXAException() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAException(int error) {
        super(OracleXAException.errorConvert(error));
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(error));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.xaError = OracleXAException.errorConvert(error);
            this.primary = error & 0xFFFF;
            this.secondary = error >> 16;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAException(int error, int _xaError) {
        super(OracleXAException.errorConvert(error, _xaError));
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(error) + ", " + OracleLog.argument(_xaError));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.xaError = OracleXAException.errorConvert(error, _xaError);
            this.primary = error & 0xFFFF;
            this.secondary = error >> 16;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    public OracleXAException(SQLException sqlex, int _xaError) {
        this(sqlex.getErrorCode(), _xaError);
        this.initCause(sqlex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAException newXAException(OracleConnection conn, int error) {
        long __ol_nanos__ = 0L;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(error));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((xacode = (xaexc = new OracleXAException(error)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleXAException oracleXAException = xaexc;
            return oracleXAException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAException newXAException(OracleConnection conn, int error, int xaerror) {
        long __ol_nanos__ = 0L;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(error) + ", " + OracleLog.argument(xaerror));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((xacode = (xaexc = new OracleXAException(error, xaerror)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleXAException oracleXAException = xaexc;
            return oracleXAException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAException newXAException(OracleConnection conn, SQLException sqlexc, int xaerror) {
        long __ol_nanos__ = 0L;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sqlexc) + ", " + OracleLog.argument(xaerror));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((xacode = (xaexc = new OracleXAException(sqlexc, xaerror)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleXAException oracleXAException = xaexc;
            return oracleXAException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int errorConvert(int err) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(err));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = OracleXAException.errorConvert(err, -3);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int errorConvert(int err, int defaultErrorCode) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(err) + ", " + OracleLog.argument(defaultErrorCode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            switch (err & 0xFFFF) {
                case 24756: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -4");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n2 = -4;
                    return n2;
                }
                case 25351: 
                case 30006: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 4");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n3 = 4;
                    return n3;
                }
                case 24764: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 7");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n4 = 7;
                    return n4;
                }
                case 24765: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 6");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n5 = 6;
                    return n5;
                }
                case 24766: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 5");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n6 = 5;
                    return n6;
                }
                case 24767: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 3");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n7 = 3;
                    return n7;
                }
                case 28: 
                case 1033: 
                case 1034: 
                case 1041: 
                case 1089: 
                case 1090: 
                case 3113: 
                case 3114: 
                case 12571: 
                case 17002: 
                case 17008: 
                case 17410: 
                case 24768: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -7");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n8 = -7;
                    return n8;
                }
                case 2056: 
                case 17448: 
                case 24763: 
                case 24769: 
                case 24770: 
                case 24775: 
                case 24776: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -6");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n9 = -6;
                    return n9;
                }
                case 2091: 
                case 2092: 
                case 24761: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 100");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n10 = 100;
                    return n10;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + defaultErrorCode);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n11 = defaultErrorCode;
            return n11;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getXAError() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xaError);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.xaError;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOracleError() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.primary);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.primary;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOracleSQLError() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.secondary);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.secondary;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXAErrorMessage(int eCode) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(eCode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            switch (eCode) {
                case 7: {
                    String string = "The transaction branch has been heuristically committed.";
                    return string;
                }
                case 8: {
                    String string = "The transaction branch may have been heuristically completed.";
                    return string;
                }
                case 5: {
                    String string = "The transaction branch has been heuristically committed and rolled back.";
                    return string;
                }
                case 6: {
                    String string = "The transaction branch has been heuristically rolled back.";
                    return string;
                }
                case 9: {
                    String string = "Resumption must occur where suspension occured.";
                    return string;
                }
                case 100: {
                    String string = "The inclusive lower bound oof the rollback codes.";
                    return string;
                }
                case 101: {
                    String string = "Rollback was caused by communication failure.";
                    return string;
                }
                case 102: {
                    String string = "A deadlock was detected.";
                    return string;
                }
                case 107: {
                    String string = "The inclusive upper bound of the rollback error code.";
                    return string;
                }
                case 103: {
                    String string = "A condition that violates the integrity of the resource was detected.";
                    return string;
                }
                case 104: {
                    String string = "The resource manager rolled back the transaction branch for a reason not on this list.";
                    return string;
                }
                case 105: {
                    String string = "A protocol error occured in the resource manager.";
                    return string;
                }
                case 106: {
                    String string = "A transaction branch took too long.";
                    return string;
                }
                case 3: {
                    String string = "The transaction branch has been read-only and has been committed.";
                    return string;
                }
                case 4: {
                    String string = "Routine returned with no effect and may be reissued.";
                    return string;
                }
                case -2: {
                    String string = "Asynchronous operation already outstanding.";
                    return string;
                }
                case -8: {
                    String string = "The XID already exists.";
                    return string;
                }
                case -5: {
                    String string = "Invalid arguments were given.";
                    return string;
                }
                case -4: {
                    String string = "The XID is not valid.";
                    return string;
                }
                case -9: {
                    String string = "The resource manager is doing work outside global transaction.";
                    return string;
                }
                case -6: {
                    String string = "Routine was invoked in an inproper context.";
                    return string;
                }
                case -3: {
                    String string = "A resource manager error has occured in the transaction branch.";
                    return string;
                }
                case -7: {
                    String string = "Resource manager is unavailable.";
                    return string;
                }
            }
            String string = "Internal XA Error";
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXAException"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

