/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class DataDescriptorPacket
extends Packet
implements SQLnetDef {
    int totalDataLength;
    int descriptorFLaG;
    int[] sdd = new int[26];
    Packet packet;
    boolean useLongDescriptor = false;
    private static final byte[] STANDARD_SDD_MAX_DD = new byte[]{0, 72, 0, 0, 15, 0, 0, 0, 0, 0, 0, 2, 0, 25, -1, -26, 0, 0, 0, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public DataDescriptorPacket(SessionAtts sAtts) {
        super(sAtts, 72, 15, 0);
    }

    public DataDescriptorPacket(Packet _packet, SessionAtts sAtts) {
        super(sAtts);
        this.packet = _packet;
        this.buffer = this.packet.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receive() throws IOException, NetException {
        block17: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DataDescriptorPacket.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.packet.receive();
                this.descriptorFLaG = (this.buffer[8] & 0xFF) << 24 | (this.buffer[9] & 0xFF) << 16 | (this.buffer[10] & 0xFF) << 8 | this.buffer[11] & 0xFF;
                this.useLongDescriptor = (this.descriptorFLaG & 2) == 0;
                this.totalDataLength = (this.buffer[12] & 0xFF) << 24 | (this.buffer[13] & 0xFF) << 16 | (this.buffer[14] & 0xFF) << 8 | this.buffer[15] & 0xFF;
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    DataDescriptorPacket.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "descriptorFlag=" + this.descriptorFLaG + ", useLongDescriptor=" + this.useLongDescriptor + ", totalDataLength=" + this.totalDataLength, this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DataDescriptorPacket.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(int totalLength, boolean marker) throws IOException {
        block34: {
            long __ol_nanos__ = 0L;
            try {
                int i2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DataDescriptorPacket.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(totalLength) + ", " + OracleLog.argument(marker));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (totalLength == 1703910 && !marker) {
                    OutputStream outputStream = this.sAtts.ntOutputStream;
                    synchronized (outputStream) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                DataDescriptorPacket.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(1):totalLength=" + totalLength + ", marker=" + marker + "\n" + this.dumpBytes(STANDARD_SDD_MAX_DD, 0, STANDARD_SDD_MAX_DD.length), this.sAtts.traceId);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        this.sAtts.ntOutputStream.write(STANDARD_SDD_MAX_DD, 0, STANDARD_SDD_MAX_DD.length);
                        break block34;
                    }
                }
                this.useLongDescriptor = false;
                this.descriptorFLaG = 2;
                if (marker) {
                    this.descriptorFLaG |= 1;
                }
                int nbOfDD = 0;
                int remainingBytes = totalLength;
                while (remainingBytes > 0) {
                    this.sdd[nbOfDD] = remainingBytes > 65535 ? 65535 : remainingBytes;
                    remainingBytes -= this.sdd[nbOfDD];
                    ++nbOfDD;
                }
                this.writeB4ToBuffer(this.buffer, 8, this.descriptorFLaG);
                this.writeB4ToBuffer(this.buffer, 12, totalLength);
                this.writeB4ToBuffer(this.buffer, 16, nbOfDD);
                for (i2 = 0; i2 < nbOfDD; ++i2) {
                    this.writeB2ToBuffer(this.buffer, 20 + i2 * 2, this.sdd[i2]);
                }
                for (i2 = nbOfDD; i2 < 26; ++i2) {
                    this.writeB2ToBuffer(this.buffer, 20 + i2 * 2, 0);
                }
                OutputStream outputStream = this.sAtts.ntOutputStream;
                synchronized (outputStream) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            DataDescriptorPacket.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(2): totalLength=" + totalLength + ", marker=" + marker + "\n" + this.dumpBytes(this.buffer, 0, 72), this.sAtts.traceId);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.sAtts.ntOutputStream.write(this.buffer, 0, 72);
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DataDescriptorPacket.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    void writeB4ToBuffer(byte[] b2, int off, int value) {
        byte b1 = (byte)((value & 0xFF000000) >>> 24 & 0xFF);
        byte b22 = (byte)((value & 0xFF0000) >>> 16 & 0xFF);
        byte b3 = (byte)((value & 0xFF00) >>> 8 & 0xFF);
        byte b4 = (byte)(value & 0xFF);
        b2[off] = b1;
        b2[off + 1] = b22;
        b2[off + 2] = b3;
        b2[off + 3] = b4;
    }

    void writeB2ToBuffer(byte[] b2, int off, int value) {
        byte b3 = (byte)((value & 0xFF00) >>> 8 & 0xFF);
        byte b4 = (byte)(value & 0xFF);
        b2[off] = b3;
        b2[off + 1] = b4;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.net.ns");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.net.ns.DataDescriptorPacket"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

