/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.DataDescriptorPacket;
import oracle.net.ns.DataPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class NetInputStream
extends InputStream
implements SQLnetDef {
    protected DataPacket daPkt;
    protected DataDescriptorPacket ddPkt;
    protected MarkerPacket mkPkt;
    protected SessionAtts sAtts;
    private byte[] tmpBuf = new byte[1];

    public NetInputStream(SessionAtts sAtts) {
        this.sAtts = sAtts;
        this.daPkt = new DataPacket(sAtts);
        this.ddPkt = new DataDescriptorPacket(this.daPkt, sAtts);
    }

    @Override
    public int read() throws IOException, NetException, BreakNetException {
        return this.read(this.tmpBuf) < 0 ? -1 : this.tmpBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] userBuffer) throws IOException, NetException, BreakNetException {
        return this.read(userBuffer, 0, userBuffer.length);
    }

    public boolean readZeroCopyIO(byte[] userBuffer, int offset, int[] bytesRead) throws IOException, NetException, BreakNetException {
        boolean markIsPresent = false;
        if (this.sAtts.nsOutputStream.available() > 0) {
            this.sAtts.nsOutputStream.flush();
        }
        this.ddPkt.receive();
        int nbOfBytes = this.ddPkt.totalDataLength;
        if ((this.ddPkt.descriptorFLaG & 1) != 0) {
            markIsPresent = true;
        }
        if (userBuffer.length < offset + nbOfBytes) {
            throw new IOException("Assertion Failed");
        }
        int bytesReadSoFar = this.ddPkt.packet.readLocal(userBuffer, offset, nbOfBytes);
        while (bytesReadSoFar < nbOfBytes) {
            try {
                if ((bytesReadSoFar += this.sAtts.ntInputStream.read(userBuffer, bytesReadSoFar + offset, nbOfBytes - bytesReadSoFar)) > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException exp) {
                throw new NetException(504);
            }
        }
        bytesRead[0] = bytesReadSoFar;
        return markIsPresent;
    }

    @Override
    public int read(byte[] userBuffer, int off, int len) throws IOException, NetException, BreakNetException {
        int bytesRead = 0;
        try {
            do {
                if (this.daPkt != null && this.daPkt.availableBytesToRead > 0 && this.daPkt.type != 7) continue;
                this.getNextPacket();
            } while ((bytesRead += this.daPkt.getDataFromBuffer(userBuffer, off + bytesRead, len - bytesRead)) < len);
        }
        catch (NetException ne) {
            if (ne.getErrorNumber() == 0) {
                return -1;
            }
            throw ne;
        }
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        return this.daPkt.availableBytesToRead;
    }

    protected void getNextPacket() throws IOException, NetException, BreakNetException {
        if (this.sAtts.dataEOF) {
            throw new NetException(202);
        }
        if (this.sAtts.nsOutputStream.available() > 0) {
            this.sAtts.nsOutputStream.flush();
        }
        this.daPkt.receive();
        switch (this.daPkt.type) {
            case 6: {
                this.daPkt.availableBytesToRead = this.daPkt.dataLen;
                break;
            }
            case 12: {
                this.mkPkt = new MarkerPacket(this.daPkt);
                this.daPkt.availableBytesToRead = 0;
                this.sAtts.onBreakReset = this.mkPkt.isBreakPkt();
                this.processMarker();
                throw new BreakNetException(500);
            }
            case 7: {
                this.daPkt.availableBytesToRead = this.daPkt.dataLen;
                break;
            }
            default: {
                throw new NetException(205);
            }
        }
    }

    protected void processMarker() throws IOException, NetException, BreakNetException {
    }

    void poolEnabled(boolean value) throws IOException, NetException, BreakNetException {
        if (value) {
            this.daPkt.setFlags(1);
        }
    }

    void reinitialize(SessionAtts _sAtts) throws NetException {
        this.sAtts = _sAtts;
    }

    Packet getCurrentPacket() throws IOException, NetException {
        return this.daPkt;
    }
}

