/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.SocketFactory;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    static final String SDP_SOCKET_FACTORY_NAME = "com.oracle.net.SDPSocketFactory";
    static SocketFactory SDP_SOCKET_FACTORY = null;
    int port;
    String host;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;
    private static Hashtable<String, InetAddress[]> inetaddressesCache = new Hashtable();
    private static Hashtable<String, Integer> circularOffsets = new Hashtable();

    private static SocketFactory getSDPSocketFactory() throws IOException {
        if (SDP_SOCKET_FACTORY == null) {
            try {
                Class<?> factoryClass = Class.forName(SDP_SOCKET_FACTORY_NAME);
                Method getDefault = factoryClass.getMethod("getDefault", new Class[0]);
                SDP_SOCKET_FACTORY = (SocketFactory)getDefault.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("SDP enabled, but SDP SocketFactory not in classpath", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IOException("SDP enabled but unable to get default SDP SocketFactory", ex);
            }
            catch (IllegalAccessException ex) {
                throw new IOException("SDP enabled, but SDP SocketFactory could not be accessed", ex);
            }
            catch (InvocationTargetException ex) {
                throw new IOException("SDP enabled, but SDP SocketFactory raised an exception", ex);
            }
        }
        return SDP_SOCKET_FACTORY;
    }

    public TcpNTAdapter(String address, Properties socketOptions) throws NLException {
        this.socketOptions = socketOptions;
        NVNavigator nav = new NVNavigator();
        NVPair nvpAddr = new NVFactory().createNVPair(address);
        NVPair nvpHost = nav.findNVPair(nvpAddr, "HOST");
        NVPair nvpPort = nav.findNVPair(nvpAddr, "PORT");
        if (nvpHost == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nvpHost.getAtom();
        if (nvpPort != null) {
            try {
                this.port = Integer.parseInt(nvpPort.getAtom());
            }
            catch (Exception e2) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(e2);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
    }

    @Override
    public void connect() throws IOException {
        String c_timeout = (String)this.socketOptions.get(2);
        int retries = Integer.parseInt((String)this.socketOptions.get(17));
        boolean forceDNSLoadBalancing = Boolean.parseBoolean((String)this.socketOptions.get(18));
        boolean enableSDP = Boolean.parseBoolean((String)this.socketOptions.get(19));
        InetAddress[] inetAddresses = InetAddress.getAllByName(this.host);
        if (forceDNSLoadBalancing && inetAddresses.length > 1) {
            inetAddresses = TcpNTAdapter.getAddressesInCircularOrder(this.host, inetAddresses);
        }
        int attempts = retries * inetAddresses.length;
        block4: for (int i2 = 0; i2 < retries; ++i2) {
            int count = 0;
            while (true) {
                InetAddress inet = inetAddresses[count];
                ++count;
                --attempts;
                this.socket = enableSDP ? TcpNTAdapter.getSDPSocketFactory().createSocket() : new Socket();
                try {
                    this.socket.connect(new InetSocketAddress(inet, this.port), Integer.parseInt(c_timeout));
                    break block4;
                }
                catch (IOException ea) {
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (attempts > 0) continue;
                    throw ea;
                    if (count < inetAddresses.length) continue;
                    continue block4;
                }
                break;
            }
        }
        this.setOption(3, c_timeout);
        this.setSocketOptions();
    }

    public void setSocketOptions() throws IOException {
        String temp = (String)this.socketOptions.get(0);
        if (temp != null) {
            this.setOption(0, temp);
        }
        if ((temp = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        switch (option) {
            case 0: {
                String tmp = (String)value;
                this.socket.setTcpNoDelay(tmp.equals("YES"));
                break;
            }
            case 1: {
                String tmp = (String)value;
                if (!tmp.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: {
                this.sockTimeout = Integer.parseInt((String)value);
                this.socket.setSoTimeout(this.sockTimeout);
                break;
            }
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        switch (option) {
            case 1: {
                return "" + this.sockTimeout;
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public void sendUrgentByte(int urgentData) throws IOException {
        this.socket.sendUrgentData(urgentData);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(Properties prop) throws IOException, NetException {
        String tmp = (String)prop.get("oracle.net.READ_TIMEOUT");
        if (tmp == null) {
            tmp = "0";
        }
        this.setOption(3, tmp);
    }

    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    private static final synchronized InetAddress[] getAddressesInCircularOrder(String hostname, InetAddress[] inetAddressesFromJVM) {
        InetAddress[] cachedAddresses = inetaddressesCache.get(hostname);
        Integer offset = circularOffsets.get(hostname);
        if (cachedAddresses == null || !TcpNTAdapter.areEquals(cachedAddresses, inetAddressesFromJVM)) {
            offset = new Integer(0);
            cachedAddresses = inetAddressesFromJVM;
            inetaddressesCache.put(hostname, inetAddressesFromJVM);
            circularOffsets.put(hostname, offset);
        }
        InetAddress[] addrb = TcpNTAdapter.getCopyAddresses(cachedAddresses, offset);
        circularOffsets.put(hostname, new Integer((offset + 1) % cachedAddresses.length));
        return addrb;
    }

    private static final boolean areEquals(InetAddress[] add1, InetAddress[] add2) {
        if (add1.length != add2.length) {
            return false;
        }
        for (int i2 = 0; i2 < add1.length; ++i2) {
            if (add1[i2].equals(add2[i2])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] add, int nbOfRotation) {
        InetAddress[] addcp = new InetAddress[add.length];
        for (int i2 = 0; i2 < add.length; ++i2) {
            addcp[i2] = add[(i2 + nbOfRotation) % add.length];
        }
        return addcp;
    }
}

