/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.net.jdbc.nl.NLException;
import oracle.net.ns.NetException;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsConfigure;

public class TcpsNTAdapter
extends TcpNTAdapter {
    String matchSSLServerCertDNWith;
    boolean fullDNMatch;
    SSLSocketFactory l_sslSockFac;
    Socket underlyingSocket = null;
    SSLSocket socketWithListener;

    public TcpsNTAdapter(String address, Properties socketOptions) throws NLException {
        super(address, socketOptions);
    }

    @Override
    public void connect() throws IOException {
        this.l_sslSockFac = CustomSSLSocketFactory.getSSLSocketFactory(this.socketOptions);
        this.underlyingSocket = new Socket();
        InetSocketAddress sockAddress = new InetSocketAddress(this.host, this.port);
        String connectTimeoutString = (String)this.socketOptions.get(2);
        try {
            int connectTimeout = connectTimeoutString == null ? 0 : Integer.parseInt(connectTimeoutString);
            this.underlyingSocket.connect(sockAddress, connectTimeout);
            this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
            String temp = (String)this.socketOptions.get(3);
            if (temp != null) {
                this.setOption(3, temp);
            }
            this.setSSLSocketOptions();
        }
        catch (NumberFormatException ex) {
            throw new NetException(505);
        }
    }

    public void renegotiateSession() throws IOException {
        this.socketWithListener = (SSLSocket)this.socket;
        this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
        String temp = (String)this.socketOptions.get(3);
        if (temp != null) {
            this.setOption(3, temp);
        }
        this.setSSLSocketOptions();
    }

    public void setSSLSocketOptions() throws IOException {
        super.setSocketOptions();
        SSLSocket sslSocket = (SSLSocket)this.socket;
        sslSocket.setUseClientMode(true);
        TcpsConfigure.configureVersion(sslSocket, (String)this.socketOptions.get(6));
        TcpsConfigure.configureCipherSuites(sslSocket, (String)this.socketOptions.get(7));
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        SSLSocket sslSocket = (SSLSocket)this.socket;
        switch (option) {
            case 8: {
                this.setServerDNMatchValue((String[])value);
                break;
            }
            case 7: {
                if (((String)value).equalsIgnoreCase("TRUE")) {
                    this.fullDNMatch = true;
                    break;
                }
                this.fullDNMatch = false;
                break;
            }
            default: {
                super.setOption(option, value);
            }
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        SSLSocket sslSocket = (SSLSocket)this.socket;
        switch (option) {
            case 2: {
                String cipherSuiteInUse = sslSocket.getSession().getCipherSuite();
                if (cipherSuiteInUse != null && cipherSuiteInUse.indexOf("NULL") == -1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 5: {
                return sslSocket.getSession().getCipherSuite();
            }
            case 3: {
                X509Certificate l_certificate = (X509Certificate)sslSocket.getSession().getPeerCertificates()[0];
                return l_certificate.getSubjectDN().getName();
            }
            case 4: {
                return sslSocket.getSession().getPeerCertificateChain();
            }
            case 6: {
                String sslServerDNMatchRequiredString = (String)this.socketOptions.get(4);
                if (sslServerDNMatchRequiredString == null) {
                    sslServerDNMatchRequiredString = System.getProperty("oracle.net.ssl_server_dn_match", "false");
                }
                if (sslServerDNMatchRequiredString.equalsIgnoreCase("YES") || sslServerDNMatchRequiredString.equalsIgnoreCase("ON") || sslServerDNMatchRequiredString.equalsIgnoreCase("TRUE")) {
                    X509Certificate peerCertificate = (X509Certificate)sslSocket.getSession().getPeerCertificates()[0];
                    String serverCertDN = peerCertificate.getSubjectDN().getName();
                    if (TcpsConfigure.matchServerDN(serverCertDN, this.matchSSLServerCertDNWith, this.fullDNMatch)) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                return "TRUE";
            }
        }
        return super.getOption(option);
    }

    public void setServerDNMatchValue(String[] value) {
        String origSSLServerCertDN = value[0];
        String origServiceName = value[1];
        String origSid = value[2];
        if (origSSLServerCertDN != null) {
            this.matchSSLServerCertDNWith = origSSLServerCertDN;
            this.fullDNMatch = true;
        } else if (origServiceName != null) {
            this.matchSSLServerCertDNWith = origServiceName.indexOf(46) != -1 ? "CN=" + origServiceName.substring(0, origServiceName.indexOf(46)) : "CN=" + origServiceName.trim();
        } else if (origSid != null) {
            this.matchSSLServerCertDNWith = origSid.indexOf(46) != -1 ? "CN=" + origSid.substring(0, origSid.indexOf(46)) : "CN=" + origSid.trim();
        }
    }
}

