/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTF
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 3, 0};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetUTF(int id) {
        super(id);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(id));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.rep = 2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLossyFrom(CharacterSet from) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = !from.isUnicode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        long __ol_nanos__ = 0L;
        try {
            boolean ok;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(source));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = ok = source.rep <= 1024;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ok);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = ok;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnicode() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                char[] chars = new char[bytes.length];
                int[] countArr = new int[]{count};
                int chars_len = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, 0, countArr, true);
                String __result__ = new String(chars, 0, chars_len);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = __result__;
                return string;
            }
            catch (SQLException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = "";
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return string;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                char[] chars = new char[bytes.length];
                int[] countArr = new int[]{count};
                int chars_len = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, 0, countArr, false);
                String __result__ = new String(chars, 0, chars_len);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = __result__;
                return string;
            }
            catch (SQLException e2) {
                CharacterSetUTF.failUTFConversion();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = "";
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return string;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convertWithReplacement(String str) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = CharacterSetUTF.stringToUTF(str);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(String str) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = CharacterSetUTF.stringToUTF(str);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from) + ", " + OracleLog.argument(source) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (from.rep == 2) {
                result = CharacterSetUTF.useOrCopy(source, offset, count);
            } else {
                String s2 = from.toString(source, offset, count);
                result = CharacterSetUTF.stringToUTF(s2);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            char[] chars;
            block37: {
                byte c2;
                int len;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTF.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                byte[] bytes = walker.bytes;
                int bytes_index = walker.next;
                int bytes_end = walker.end;
                if (bytes_index >= bytes_end) {
                    CharacterSetUTF.failUTFConversion();
                }
                if ((len = CharacterSetUTF.getUTFByteLength(c2 = bytes[bytes_index])) == 0 || bytes_index + (len - 1) >= bytes_end) {
                    CharacterSetUTF.failUTFConversion();
                }
                if (len == 3 && CharacterSetUTF.isHiSurrogate(c2, bytes[bytes_index + 1]) && bytes_index + 5 < bytes_end) {
                    len = 6;
                }
                try {
                    chars = new char[2];
                    int[] lenArr = new int[]{len};
                    int chars_len = CharacterSet.convertUTFBytesToJavaChars(bytes, bytes_index, chars, 0, lenArr, false);
                    walker.next += len;
                    if (chars_len != 1) break block37;
                    char __result__ = chars[0];
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetUTF.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    char c3 = __result__;
                    return c3;
                }
                catch (SQLException e2) {
                    CharacterSetUTF.failUTFConversion();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetUTF.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n2 = 0;
                    return n2;
                }
            }
            int __result__ = chars[0] << 16 | chars[1];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((c2 & 0xFFFF0000) != 0) {
                CharacterSetUTF.need(buffer, 6);
                char[] chars = new char[]{(char)(c2 >>> 16), (char)c2};
                n2 = CharacterSet.convertJavaCharsToUTFBytes(chars, 0, buffer.bytes, buffer.next, 2);
            } else {
                CharacterSetUTF.need(buffer, 3);
                char[] chars = new char[]{(char)c2};
                n2 = CharacterSet.convertJavaCharsToUTFBytes(chars, 0, buffer.bytes, buffer.next, 1);
            }
            buffer.next += n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getUTFByteLength(byte b2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(b2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = m_byteLen[b2 >>> 4 & 0xF];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isHiSurrogate(byte b2, byte b22) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(b2) + ", " + OracleLog.argument(b22));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = b2 == -19 && b22 >= -96;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int encodedByteLength(String s2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = CharacterSet.stringUTFLength(s2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int encodedByteLength(char[] carray) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(carray));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = CharacterSet.charArrayUTF8Length(carray);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTF.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetUTF"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

