/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.util.StringTokenizer;
import oracle.sql.Datum;
import oracle.sql.utilpack;

public class INTERVALDS
extends Datum {
    private static int MAXLEADPREC = 9;
    private static int MAXHOUR = 23;
    private static int MAXMINUTE = 59;
    private static int MAXSECOND = 59;
    private static int INTERVALDSMAXLENGTH = 11;
    private static int INTERVALDSOFFSET = 60;
    private static int INTERVALDAYOFFSET = Integer.MIN_VALUE;

    public INTERVALDS() {
        super(INTERVALDS._initIntervalDS());
    }

    public INTERVALDS(byte[] intervalDS) {
        super(intervalDS);
    }

    public INTERVALDS(String str) {
        super(INTERVALDS.toBytes(str));
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] toBytes(String str) {
        String secStr;
        String minStr;
        String hourStr;
        int indexOfspace;
        String interStr;
        int day = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int frac = 0;
        byte[] intarr = new byte[INTERVALDSMAXLENGTH];
        String fracStr = null;
        char sign = (interStr = str.trim()).charAt(0);
        int startIndex = sign != '-' && sign != '+' ? 0 : 1;
        String dayStr = (interStr = interStr.substring(startIndex)).substring(0, indexOfspace = interStr.indexOf(32));
        if (dayStr.length() > MAXLEADPREC) {
            throw new NumberFormatException();
        }
        String secondStr = interStr.substring(indexOfspace + 1);
        StringTokenizer secTok = new StringTokenizer(secondStr, ":.");
        if (!secTok.hasMoreTokens()) throw new NumberFormatException();
        try {
            hourStr = secTok.nextToken();
            minStr = secTok.nextToken();
            secStr = secTok.nextToken();
            fracStr = secTok.nextToken();
        }
        catch (Exception e2) {
            throw new NumberFormatException();
        }
        day = Integer.valueOf(dayStr);
        hour = Integer.valueOf(hourStr);
        min = Integer.valueOf(minStr);
        sec = Integer.valueOf(secStr);
        if (hour > MAXHOUR) {
            throw new NumberFormatException();
        }
        if (min > MAXMINUTE) {
            throw new NumberFormatException();
        }
        if (sec > MAXSECOND) {
            throw new NumberFormatException();
        }
        if (fracStr.length() > MAXLEADPREC) throw new NumberFormatException();
        if (fracStr.length() < MAXLEADPREC) {
            char[] fullfracStr = new char[MAXLEADPREC];
            for (int i2 = 0; i2 < fracStr.length(); ++i2) {
                fullfracStr[i2] = fracStr.charAt(i2);
            }
            for (int j2 = i2; j2 < MAXLEADPREC; ++j2) {
                fullfracStr[j2] = 48;
            }
            String localfracStr = new String(fullfracStr);
            frac = Integer.valueOf(localfracStr);
        } else {
            frac = Integer.valueOf(fracStr);
        }
        if (sign == '-') {
            day = -day;
            hour = -hour;
            min = -min;
            sec = -sec;
            frac = -frac;
        }
        intarr[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(day += INTERVALDAYOFFSET);
        intarr[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(day);
        intarr[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(day);
        intarr[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(day);
        intarr[4] = (byte)(hour + INTERVALDSOFFSET);
        intarr[5] = (byte)(min + INTERVALDSOFFSET);
        intarr[6] = (byte)(sec + INTERVALDSOFFSET);
        intarr[7] = utilpack.RIGHTSHIFTFIRSTNIBBLE(frac += INTERVALDAYOFFSET);
        intarr[8] = utilpack.RIGHTSHIFTSECONDNIBBLE(frac);
        intarr[9] = utilpack.RIGHTSHIFTTHIRDNIBBLE(frac);
        intarr[10] = utilpack.RIGHTSHIFTFOURTHNIBBLE(frac);
        return intarr;
    }

    public static String toString(byte[] inparray) {
        int i2;
        boolean positive = true;
        int intFrac = 0;
        int intDay = utilpack.LEFTSHIFTFIRSTNIBBLE(inparray[0]);
        intDay |= utilpack.LEFTSHIFTSECONDNIBBLE(inparray[1]);
        intDay |= utilpack.LEFTSHIFTTHIRDNIBBLE(inparray[2]);
        intDay |= inparray[3] & 0xFF;
        intDay -= INTERVALDAYOFFSET;
        int intHour = inparray[4] - INTERVALDSOFFSET;
        int intMin = inparray[5] - INTERVALDSOFFSET;
        int intSec = inparray[6] - INTERVALDSOFFSET;
        intFrac = utilpack.LEFTSHIFTFIRSTNIBBLE(inparray[7]);
        intFrac |= utilpack.LEFTSHIFTSECONDNIBBLE(inparray[8]);
        intFrac |= utilpack.LEFTSHIFTTHIRDNIBBLE(inparray[9]);
        intFrac |= inparray[10] & 0xFF;
        intFrac -= INTERVALDAYOFFSET;
        if (intDay < 0) {
            positive = false;
            intDay = -intDay;
            intHour = -intHour;
            intMin = -intMin;
            intSec = -intSec;
            intFrac = -intFrac;
        } else if (intHour < 0) {
            positive = false;
            intHour = -intHour;
            intMin = -intMin;
            intSec = -intSec;
            intFrac = -intFrac;
        } else if (intMin < 0) {
            positive = false;
            intMin = -intMin;
            intSec = -intSec;
            intFrac = -intFrac;
        } else if (intSec < 0) {
            positive = false;
            intSec = -intSec;
            intFrac = -intFrac;
        } else if (intFrac < 0) {
            positive = false;
            intFrac = -intFrac;
        }
        String fracString = String.format("%09d", intFrac);
        char[] fracChars = fracString.toCharArray();
        for (i2 = fracChars.length; i2 > 1 && fracChars[i2 - 1] == '0'; --i2) {
        }
        fracString = fracString.substring(0, i2);
        if (positive) {
            return intDay + " " + intHour + ":" + intMin + ":" + intSec + "." + fracString;
        }
        return "-" + intDay + " " + intHour + ":" + intMin + ":" + intSec + "." + fracString;
    }

    @Override
    public Object toJdbc() {
        return this;
    }

    @Override
    public String stringValue() {
        return INTERVALDS.toString(this.getBytes());
    }

    public String toString() {
        return INTERVALDS.toString(this.getBytes());
    }

    @Override
    public boolean isConvertibleTo(Class cls) {
        return cls.getName().compareTo("java.lang.String") == 0;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        INTERVALDS[] intds = new INTERVALDS[arraySize];
        return intds;
    }

    private static byte[] _initIntervalDS() {
        byte[] intarr = new byte[INTERVALDSMAXLENGTH];
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int fsec = 0;
        intarr[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(day += INTERVALDAYOFFSET);
        intarr[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(day);
        intarr[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(day);
        intarr[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(day);
        intarr[4] = (byte)(hour + INTERVALDSOFFSET);
        intarr[5] = (byte)(minute + INTERVALDSOFFSET);
        intarr[6] = (byte)(second + INTERVALDSOFFSET);
        intarr[7] = utilpack.RIGHTSHIFTFIRSTNIBBLE(fsec += INTERVALDAYOFFSET);
        intarr[8] = utilpack.RIGHTSHIFTSECONDNIBBLE(fsec);
        intarr[9] = utilpack.RIGHTSHIFTTHIRDNIBBLE(fsec);
        intarr[10] = utilpack.RIGHTSHIFTFOURTHNIBBLE(fsec);
        return intarr;
    }
}

