/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

public class TIMESTAMPTZ
extends Datum {
    static final Calendar CAL_GMT_US = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
    static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public TIMESTAMPTZ() {
        super(TIMESTAMPTZ.initTimestamptz());
    }

    public TIMESTAMPTZ(byte[] timestamptz) {
        super(timestamptz);
    }

    public TIMESTAMPTZ(Connection conn, Date date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date));
    }

    public TIMESTAMPTZ(Connection conn, Date date, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date, cal));
    }

    public TIMESTAMPTZ(Connection conn, Time time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, time));
    }

    public TIMESTAMPTZ(Connection conn, Time time, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, time, cal));
    }

    public TIMESTAMPTZ(Connection conn, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, timestamp));
    }

    public TIMESTAMPTZ(Connection conn, Timestamp timestamp, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, timestamp, cal));
    }

    public TIMESTAMPTZ(Connection conn, DATE date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date));
    }

    public TIMESTAMPTZ(Connection conn, String str) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, str));
    }

    public TIMESTAMPTZ(Connection conn, String str, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, str, cal));
    }

    public static Date toDate(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            result[i2] = timestamptz[i2] & 0xFF;
        }
        int year = TIMESTAMPTZ.getJavaYear(result[0], result[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        cal.set(14, 0);
        if ((result[11] & REGIONIDBIT) != 0) {
            int regionID = TIMESTAMPTZ.getHighOrderbits(result[11]);
            TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
            if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result[12]))) {
                tzTab.updateTable(conn, regionID);
            }
            int offset = tzTab.getOffset(cal, regionID);
            cal.add(10, offset / HOUR_MILLISECOND);
            cal.add(12, offset % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        } else {
            cal.add(10, result[11] - OFFSET_HOUR);
            cal.add(12, result[12] - OFFSET_MINUTE);
        }
        long millis = cal.getTime().getTime();
        return new Date(millis);
    }

    public static Date toDate2(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            result[i2] = timestamptz[i2] & 0xFF;
        }
        int year = TIMESTAMPTZ.getJavaYear(result[0], result[1]);
        Calendar cal = (Calendar)CAL_GMT_US.clone();
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        cal.set(14, 0);
        long millis = cal.getTime().getTime();
        return new Date(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time toTime(Connection conn, byte[] timestamptz) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(timestamptz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int[] result = new int[13];
            for (int i2 = 0; i2 < 13; ++i2) {
                result[i2] = timestamptz[i2] & 0xFF;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TIMEZONE_UTC);
            int year = TIMESTAMPTZ.getJavaYear(result[0], result[1]);
            cal.set(1, year);
            cal.set(2, result[2] - 1);
            cal.set(5, result[3]);
            cal.set(11, result[4] - 1);
            cal.set(12, result[5] - 1);
            cal.set(13, result[6] - 1);
            cal.set(14, 0);
            Time __result__ = new Time(cal.getTimeInMillis());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = __result__;
            return time;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static DATE toDATE(Connection conn, byte[] timestamptz) throws SQLException {
        return new DATE(TIMESTAMPTZ.toTimestampInSessionTimezone(conn, timestamptz));
    }

    public static TIMESTAMP toTIMESTAMP(Connection conn, byte[] timestamptz) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestampInSessionTimezone(conn, timestamptz));
    }

    public static Timestamp toTimestamp(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            result[i2] = timestamptz[i2] & 0xFF;
        }
        Calendar cal = Calendar.getInstance();
        Calendar gcal = (Calendar)CAL_GMT_US.clone();
        Calendar cal1 = Calendar.getInstance();
        int year = TIMESTAMPTZ.getJavaYear(result[0], result[1]);
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        cal.set(14, 0);
        gcal.set(1, year);
        gcal.set(2, result[2] - 1);
        gcal.set(5, result[3]);
        gcal.set(11, result[4] - 1);
        gcal.set(12, result[5] - 1);
        gcal.set(13, result[6] - 1);
        gcal.set(14, 0);
        long timeInMillis = cal.getTime().getTime();
        if ((result[11] & REGIONIDBIT) != 0) {
            int regionID = TIMESTAMPTZ.getHighOrderbits(result[11]);
            TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
            if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result[12]))) {
                tzTab.updateTable(conn, regionID);
            }
            int offset = tzTab.getOffset(gcal, regionID);
            TimeZone calTZ = cal.getTimeZone();
            TimeZone cal1TZ = cal1.getTimeZone();
            if (!calTZ.inDaylightTime(cal.getTime()) && cal1TZ.inDaylightTime(new Timestamp(timeInMillis += (long)offset))) {
                timeInMillis = cal1TZ instanceof SimpleTimeZone ? (timeInMillis -= (long)((SimpleTimeZone)cal1TZ).getDSTSavings()) : (timeInMillis -= 3600000L);
            }
            if (calTZ.inDaylightTime(cal.getTime()) && !cal1TZ.inDaylightTime(new Timestamp(timeInMillis))) {
                timeInMillis = cal1TZ instanceof SimpleTimeZone ? (timeInMillis += (long)((SimpleTimeZone)calTZ).getDSTSavings()) : (timeInMillis += 3600000L);
            }
        } else {
            cal.add(10, result[11] - OFFSET_HOUR);
            cal.add(12, result[12] - OFFSET_MINUTE);
            timeInMillis = cal.getTime().getTime();
        }
        Timestamp ts = new Timestamp(timeInMillis);
        long milliGMT = gcal.getTime().getTime();
        Calendar tcal = Calendar.getInstance();
        tcal.setTimeInMillis(milliGMT);
        Calendar tcal2 = Calendar.getInstance();
        tcal2.setTime(ts);
        boolean dst1 = tcal.getTimeZone().inDaylightTime(tcal.getTime());
        boolean dst2 = tcal2.getTimeZone().inDaylightTime(tcal2.getTime());
        if (dst1 && !dst2) {
            ts = new Timestamp(timeInMillis - (long)tcal.getTimeZone().getDSTSavings());
        } else if (!dst1 && dst2) {
            ts = new Timestamp(timeInMillis + (long)tcal2.getTimeZone().getDSTSavings());
        }
        int nanos = TIMESTAMP.getNanos(timestamptz, 7);
        ts.setNanos(nanos);
        return ts;
    }

    public static Timestamp toTimestamp2(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            result[i2] = timestamptz[i2] & 0xFF;
        }
        int year = TIMESTAMPTZ.getJavaYear(result[0], result[1]);
        Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
        gmtCal.clear();
        gmtCal.set(1, year);
        gmtCal.set(2, result[2] - 1);
        gmtCal.set(5, result[3]);
        gmtCal.set(11, result[4] - 1);
        gmtCal.set(12, result[5] - 1);
        gmtCal.set(13, result[6] - 1);
        gmtCal.set(14, 0);
        long milliSec = gmtCal.getTime().getTime();
        Timestamp ts = new Timestamp(milliSec);
        int nanos = TIMESTAMP.getNanos(timestamptz, 7);
        ts.setNanos(nanos);
        return ts;
    }

    static Timestamp toTimestampInSessionTimezone(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            result[i2] = timestamptz[i2] & 0xFF;
        }
        int year = TIMESTAMPTZ.getJavaYear(result[0], result[1]);
        Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
        gmtCal.clear();
        gmtCal.set(1, year);
        gmtCal.set(2, result[2] - 1);
        gmtCal.set(5, result[3]);
        gmtCal.set(11, result[4] - 1);
        gmtCal.set(12, result[5] - 1);
        gmtCal.set(13, result[6] - 1);
        gmtCal.set(14, 0);
        Calendar sesscal = TIMESTAMPLTZ.getSessCalendar(conn);
        TIMESTAMPLTZ.TimeZoneAdjust(conn, gmtCal, sesscal);
        long milliSec = sesscal.getTime().getTime();
        Timestamp ts = new Timestamp(milliSec);
        int nanos = TIMESTAMP.getNanos(timestamptz, 7);
        ts.setNanos(nanos);
        return ts;
    }

    public static String toString(Connection conn, byte[] timestamptz) throws SQLException {
        String regname;
        Timestamp tempstamp = TIMESTAMPTZ.toTimestamp(conn, timestamptz);
        Calendar cal = Calendar.getInstance();
        cal.setTime(tempstamp);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int nanos = 0;
        nanos = (timestamptz[7] & 0xFF) << 24;
        nanos |= (timestamptz[8] & 0xFF) << 16;
        nanos |= (timestamptz[9] & 0xFF) << 8;
        nanos |= timestamptz[10] & 0xFF & 0xFF;
        if ((timestamptz[11] & REGIONIDBIT) != 0) {
            int regionID = TIMESTAMPTZ.getHighOrderbits(timestamptz[11]);
            regname = ZONEIDMAP.getRegion(regionID += TIMESTAMPTZ.getLowOrderbits(timestamptz[12]));
        } else {
            int off_hour = timestamptz[11] - OFFSET_HOUR;
            int off_minute = timestamptz[12] - OFFSET_MINUTE;
            regname = off_hour + ":";
            regname = off_minute == 0 ? regname + "00" : regname + "" + off_minute;
        }
        return TIMESTAMPTZ.toString(year, month, date, hour, minute, second, nanos, regname);
    }

    public static final String toString(int year, int month, int day, int hours, int minutes, int seconds, int nanos, String regionName) {
        String stringRep = "" + year + "-" + TIMESTAMPTZ.toStr(month) + "-" + TIMESTAMPTZ.toStr(day) + " " + TIMESTAMPTZ.toStr(hours) + ":" + TIMESTAMPTZ.toStr(minutes) + ":" + TIMESTAMPTZ.toStr(seconds);
        if (nanos >= 0) {
            int i2;
            String nanoString = String.format("%09d", nanos);
            char[] nanoChars = nanoString.toCharArray();
            for (i2 = nanoChars.length; i2 > 1 && nanoChars[i2 - 1] == '0'; --i2) {
            }
            nanoString = nanoString.substring(0, i2);
            stringRep = stringRep + "." + nanoString;
        }
        if (regionName != null) {
            stringRep = stringRep + " " + regionName;
        }
        return stringRep;
    }

    private static final String toStr(int x) {
        return x < 10 ? "0" + x : Integer.toString(x);
    }

    public Timestamp timestampValue(Connection conn) throws SQLException {
        if (((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getTimestamptzInGmt()) {
            return TIMESTAMPTZ.toTimestamp2(conn, this.getBytes());
        }
        return TIMESTAMPTZ.toTimestamp(conn, this.getBytes());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Date date) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(date));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (date == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = new byte[13];
            String locTimeZone = ((oracle.jdbc.OracleConnection)conn).getSessionTimeZone();
            Calendar cal = locTimeZone == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(locTimeZone));
            cal.setTime(date);
            boolean overlap = cal.getTimeZone().inDaylightTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            if (cal.getTimeZone().getID() == "Custom") {
                offset = cal.getTimeZone().getRawOffset();
                result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                String timeZone = cal.getTimeZone().getID();
                int regionID = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (cal.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    offset = cal.getTimeZone().getRawOffset();
                    result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                    result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
                } else {
                    TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(conn, regionID);
                    }
                    OffsetDST trans_data = new OffsetDST();
                    byte olap = tzTab.getLocalOffset(cal, regionID, trans_data);
                    offset = trans_data.getOFFSET();
                    if (overlap && olap == 1) {
                        if (trans_data.getDSTFLAG() == 0) {
                            offset += HOUR_MILLISECOND;
                        } else {
                            throw new SQLException();
                        }
                    }
                    int id = ZONEIDMAP.getID(timeZone);
                    result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(id);
                    result[11] = (byte)(result[11] | REGIONIDBIT);
                    result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(id);
                }
            }
            cal.add(10, -(offset / HOUR_MILLISECOND));
            cal.add(12, -(offset % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
            int year = cal.get(1);
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.SEVERE, "         Throwing SQLException: 268");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 268);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            result[0] = (byte)(cal.get(1) / 100 + 100);
            result[1] = (byte)(cal.get(1) % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
            result[7] = 0;
            result[8] = 0;
            result[9] = 0;
            result[10] = 0;
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Date date, Calendar cal) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(date) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (date == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = new byte[13];
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date);
            boolean overlap = cal.getTimeZone().inDaylightTime(date);
            cal1.set(11, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
            if (cal.getTimeZone().getID() == "Custom") {
                offset = cal.getTimeZone().getRawOffset();
                result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                String timeZone = cal.getTimeZone().getID();
                int regionID = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (cal.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    offset = cal.getTimeZone().getRawOffset();
                    result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                    result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
                } else {
                    TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(conn, regionID);
                    }
                    OffsetDST trans_data = new OffsetDST();
                    byte olap = tzTab.getLocalOffset(cal1, regionID, trans_data);
                    offset = trans_data.getOFFSET();
                    if (overlap && olap == 1) {
                        if (trans_data.getDSTFLAG() == 0) {
                            offset += HOUR_MILLISECOND;
                        } else {
                            throw new SQLException();
                        }
                    }
                    result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
                    result[11] = (byte)(result[11] | REGIONIDBIT);
                    result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
                }
            }
            cal1.add(10, -(offset / HOUR_MILLISECOND));
            cal1.add(12, -(offset % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
            int year = cal1.get(1);
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.SEVERE, "         Throwing SQLException: 268");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 268);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            result[0] = (byte)(cal1.get(1) / 100 + 100);
            result[1] = (byte)(cal1.get(1) % 100 + 100);
            result[2] = (byte)(cal1.get(2) + 1);
            result[3] = (byte)cal1.get(5);
            result[4] = (byte)(cal1.get(11) + 1);
            result[5] = (byte)(cal1.get(12) + 1);
            result[6] = (byte)(cal1.get(13) + 1);
            result[7] = 0;
            result[8] = 0;
            result[9] = 0;
            result[10] = 0;
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Time time) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(time));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (time == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = new byte[13];
            String locTimeZone = ((oracle.jdbc.OracleConnection)conn).getSessionTimeZone();
            Calendar cal = locTimeZone == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(locTimeZone));
            cal.setTime(time);
            if (cal.getTimeZone().inDaylightTime(time)) {
                boolean overlap = true;
            } else {
                boolean overlap = false;
            }
            cal.set(1, 1900);
            cal.set(2, 0);
            cal.set(5, 1);
            if (cal.getTimeZone().getID() == "Custom") {
                offset = cal.getTimeZone().getRawOffset();
                result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                String timeZone = cal.getTimeZone().getID();
                int regionID = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (cal.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    offset = cal.getTimeZone().getRawOffset();
                    result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                    result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
                } else {
                    TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(conn, regionID);
                    }
                    OffsetDST trans_data = new OffsetDST();
                    byte olap = tzTab.getLocalOffset(cal, regionID, trans_data);
                    offset = trans_data.getOFFSET();
                    result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
                    result[11] = (byte)(result[11] | REGIONIDBIT);
                    result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
                }
            }
            cal.add(10, -(offset / HOUR_MILLISECOND));
            cal.add(12, -(offset % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
            int year = cal.get(1);
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.SEVERE, "         Throwing SQLException: 268");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 268);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            result[0] = (byte)(cal.get(1) / 100 + 100);
            result[1] = (byte)(cal.get(1) % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
            result[7] = 0;
            result[8] = 0;
            result[9] = 0;
            result[10] = 0;
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Time time, Calendar cal) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(time) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (time == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            Calendar cal1 = Calendar.getInstance();
            byte[] result = new byte[13];
            cal1.setTime(time);
            boolean overlap = cal.getTimeZone().inDaylightTime(time);
            cal1.set(1, 1900);
            cal1.set(2, 0);
            cal1.set(5, 1);
            if (cal.getTimeZone().getID() == "Custom") {
                offset = cal.getTimeZone().getRawOffset();
                result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                String timeZone = cal.getTimeZone().getID();
                int regionID = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (cal.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    offset = cal.getTimeZone().getRawOffset();
                    result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                    result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
                } else {
                    TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(conn, regionID);
                    }
                    OffsetDST trans_data = new OffsetDST();
                    byte olap = tzTab.getLocalOffset(cal1, regionID, trans_data);
                    offset = trans_data.getOFFSET();
                    if (overlap && olap == 1) {
                        if (trans_data.getDSTFLAG() == 0) {
                            offset += HOUR_MILLISECOND;
                        } else {
                            throw new SQLException();
                        }
                    }
                    result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
                    result[11] = (byte)(result[11] | REGIONIDBIT);
                    result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
                }
            }
            cal1.add(11, -(offset / HOUR_MILLISECOND));
            cal1.add(12, -(offset % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
            int year = cal1.get(1);
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.SEVERE, "         Throwing SQLException: 268");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 268);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            result[0] = (byte)(cal1.get(1) / 100 + 100);
            result[1] = (byte)(cal1.get(1) % 100 + 100);
            result[2] = (byte)(cal1.get(2) + 1);
            result[3] = (byte)cal1.get(5);
            result[4] = (byte)(cal1.get(11) + 1);
            result[5] = (byte)(cal1.get(12) + 1);
            result[6] = (byte)(cal1.get(13) + 1);
            result[7] = 0;
            result[8] = 0;
            result[9] = 0;
            result[10] = 0;
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Timestamp timestamp) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(timestamp));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (timestamp == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = new byte[13];
            long timeInMillis = 0L;
            String locTimeZone = ((oracle.jdbc.OracleConnection)conn).getSessionTimeZone();
            if (locTimeZone == null) {
                locTimeZone = TimeZone.getDefault().getID();
                timeInMillis = timestamp.getTime();
            } else {
                int nanos = timestamp.getNanos();
                Calendar tmpCal = Calendar.getInstance();
                tmpCal.setTime(timestamp);
                int year = tmpCal.get(1);
                int month = tmpCal.get(2) + 1;
                int day = tmpCal.get(5);
                int hour = tmpCal.get(11);
                int minute = tmpCal.get(12);
                int second = tmpCal.get(13);
                double millis = nanos / 1000000;
                String dateStr = Integer.valueOf(year).toString() + "/" + Integer.valueOf(month).toString() + "/" + Integer.valueOf(day).toString() + " " + Integer.valueOf(hour).toString() + ":" + Integer.valueOf(minute).toString() + ":" + Integer.valueOf(second).toString() + ":" + Double.valueOf(millis).toString();
                TimeZone sessionTimeZone = TimeZone.getTimeZone(locTimeZone);
                SimpleDateFormat df = new SimpleDateFormat("y/M/d H:m:s:S");
                df.setTimeZone(sessionTimeZone);
                java.util.Date date = null;
                try {
                    date = df.parse(dateStr);
                }
                catch (ParseException e2) {
                    throw new SQLException(e2.getMessage());
                }
                timeInMillis = date.getTime();
            }
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(locTimeZone));
            boolean overlap = cal.getTimeZone().inDaylightTime(timestamp);
            cal.setTime(new Timestamp(timeInMillis));
            if (cal.getTimeZone().getID() == "Custom") {
                offset = cal.getTimeZone().getRawOffset();
                result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                String timeZone = cal.getTimeZone().getID();
                int regionID = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (cal.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    offset = cal.getTimeZone().getRawOffset();
                    result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                    result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
                } else {
                    TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(conn, regionID);
                    }
                    OffsetDST trans_data = new OffsetDST();
                    byte olap = tzTab.getLocalOffset(cal, regionID, trans_data);
                    offset = trans_data.getOFFSET();
                    if (overlap && olap == 1) {
                        if (trans_data.getDSTFLAG() == 0) {
                            offset += HOUR_MILLISECOND;
                        } else {
                            throw new SQLException();
                        }
                    }
                    result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
                    result[11] = (byte)(result[11] | REGIONIDBIT);
                    result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
                }
            }
            TimeZone gmtZone = TimeZone.getTimeZone("GMT");
            Calendar gmtCal = Calendar.getInstance(gmtZone, Locale.US);
            gmtCal.set(1, cal.get(1));
            gmtCal.set(2, cal.get(2));
            gmtCal.set(5, cal.get(5));
            gmtCal.set(11, cal.get(11));
            gmtCal.set(12, cal.get(12));
            gmtCal.set(13, cal.get(13));
            gmtCal.add(14, -1 * offset);
            int year = gmtCal.get(1);
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.SEVERE, "         Throwing SQLException: 268");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 268);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            result[0] = (byte)(gmtCal.get(1) / 100 + 100);
            result[1] = (byte)(gmtCal.get(1) % 100 + 100);
            result[2] = (byte)(gmtCal.get(2) + 1);
            result[3] = (byte)gmtCal.get(5);
            result[4] = (byte)(gmtCal.get(11) + 1);
            result[5] = (byte)(gmtCal.get(12) + 1);
            result[6] = (byte)(gmtCal.get(13) + 1);
            result[7] = (byte)(timestamp.getNanos() >> 24);
            result[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
            result[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
            result[10] = (byte)(timestamp.getNanos() & 0xFF);
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Timestamp timestamp, Calendar cal) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (timestamp == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = new byte[13];
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.setTime(timestamp);
            TimeZone zone = cal1.getTimeZone();
            boolean overlap = cal.getTimeZone().inDaylightTime(timestamp);
            if (cal.getTimeZone().getID() == "Custom") {
                offset = cal.getTimeZone().getRawOffset();
                result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                String timeZone = cal.getTimeZone().getID();
                int regionID = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (cal.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    offset = cal.getTimeZone().getRawOffset();
                    result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                    result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
                } else {
                    TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(conn, regionID);
                    }
                    OffsetDST trans_data = new OffsetDST();
                    byte olap = tzTab.getLocalOffset(cal1, regionID, trans_data);
                    offset = trans_data.getOFFSET();
                    if (overlap && olap == 1) {
                        if (trans_data.getDSTFLAG() == 0) {
                            offset += HOUR_MILLISECOND;
                        } else {
                            throw new SQLException();
                        }
                    }
                    result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
                    result[11] = (byte)(result[11] | REGIONIDBIT);
                    result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
                }
            }
            TimeZone gmtZone = TimeZone.getTimeZone("GMT");
            Calendar gmtCal = Calendar.getInstance(gmtZone, Locale.US);
            gmtCal.set(1, cal1.get(1));
            gmtCal.set(2, cal1.get(2));
            gmtCal.set(5, cal1.get(5));
            gmtCal.set(11, cal1.get(11));
            gmtCal.set(12, cal1.get(12));
            gmtCal.set(13, cal1.get(13));
            gmtCal.add(14, -1 * offset);
            int year = gmtCal.get(1);
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPTZ.logger().log(Level.SEVERE, "         Throwing SQLException: 268");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 268);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            result[0] = (byte)(gmtCal.get(1) / 100 + 100);
            result[1] = (byte)(gmtCal.get(1) % 100 + 100);
            result[2] = (byte)(gmtCal.get(2) + 1);
            result[3] = (byte)gmtCal.get(5);
            result[4] = (byte)(gmtCal.get(11) + 1);
            result[5] = (byte)(gmtCal.get(12) + 1);
            result[6] = (byte)(gmtCal.get(13) + 1);
            result[7] = (byte)(timestamp.getNanos() >> 24);
            result[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
            result[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
            result[10] = (byte)(timestamp.getNanos() & 0xFF);
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static byte[] toBytes(Connection conn, DATE date) throws SQLException {
        int offset;
        if (date == null) {
            return null;
        }
        byte[] result = new byte[13];
        Calendar cal = Calendar.getInstance();
        cal.setTime(DATE.toDate(date.toBytes()));
        boolean overlap = cal.getTimeZone().inDaylightTime(DATE.toDate(date.toBytes()));
        if (cal.getTimeZone().getID() == "Custom") {
            offset = cal.getTimeZone().getRawOffset();
            result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
            result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            String timeZone = cal.getTimeZone().getID();
            int regionID = ZONEIDMAP.getID(timeZone);
            if (!ZONEIDMAP.isValidID(regionID)) {
                if (cal.getTimeZone().useDaylightTime()) {
                    throw new SQLException("Timezone not supported");
                }
                offset = cal.getTimeZone().getRawOffset();
                result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                if (tzTab.checkID(regionID)) {
                    tzTab.updateTable(conn, regionID);
                }
                OffsetDST trans_data = new OffsetDST();
                byte olap = tzTab.getLocalOffset(cal, regionID, trans_data);
                offset = trans_data.getOFFSET();
                if (overlap && olap == 1) {
                    if (trans_data.getDSTFLAG() == 0) {
                        offset += HOUR_MILLISECOND;
                    } else {
                        throw new SQLException();
                    }
                }
                result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
                result[11] = (byte)(result[11] | REGIONIDBIT);
                result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
            }
        }
        cal.add(10, -(offset / HOUR_MILLISECOND));
        cal.add(12, -(offset % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
        result[0] = (byte)(cal.get(1) / 100 + 100);
        result[1] = (byte)(cal.get(1) % 100 + 100);
        result[2] = (byte)(cal.get(2) + 1);
        result[3] = (byte)cal.get(5);
        result[4] = (byte)(cal.get(11) + 1);
        result[5] = (byte)(cal.get(12) + 1);
        result[6] = (byte)(cal.get(13) + 1);
        result[7] = 0;
        result[8] = 0;
        result[9] = 0;
        result[10] = 0;
        return result;
    }

    public static byte[] toBytes(Connection conn, String str) throws SQLException {
        return TIMESTAMPTZ.toBytes(conn, Timestamp.valueOf(str));
    }

    public static byte[] toBytes(Connection conn, String str, Calendar cal) throws SQLException {
        Calendar local = Calendar.getInstance();
        Timestamp ts = Timestamp.valueOf(str);
        local.setTime(ts);
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.set(1, local.get(1));
        cal1.set(2, local.get(2));
        cal1.set(5, local.get(5));
        cal1.set(11, local.get(11));
        cal1.set(12, local.get(12));
        cal1.set(13, local.get(13));
        cal1.set(14, local.get(14));
        int nano = ts.getNanos();
        ts = new Timestamp(cal1.getTime().getTime());
        ts.setNanos(nano);
        return TIMESTAMPTZ.toBytes(conn, ts, cal);
    }

    @Override
    public String stringValue(Connection conn) throws SQLException {
        return TIMESTAMPTZ.toString(conn, this.getBytes());
    }

    public Date dateValue(Connection conn) throws SQLException {
        if (((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getTimestamptzInGmt()) {
            return TIMESTAMPTZ.toDate2(conn, this.getBytes());
        }
        return TIMESTAMPTZ.toDate(conn, this.getBytes());
    }

    public Time timeValue(Connection conn) throws SQLException {
        return TIMESTAMPTZ.toTime(conn, this.getBytes());
    }

    private static byte[] initTimestamptz() {
        byte[] tmp = new byte[13];
        Calendar cal = Calendar.getInstance();
        tmp[0] = 119;
        tmp[1] = -86;
        tmp[2] = 1;
        tmp[3] = 1;
        tmp[4] = 1;
        tmp[5] = 1;
        tmp[6] = 1;
        tmp[7] = 0;
        tmp[8] = 0;
        tmp[9] = 0;
        tmp[10] = 0;
        String timeZone = cal.getTimeZone().getID();
        tmp[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
        tmp[11] = (byte)(tmp[11] | REGIONIDBIT);
        tmp[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
        return tmp;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return null;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        Timestamp[] ts = new Timestamp[arraySize];
        return ts;
    }

    @Override
    public boolean isConvertibleTo(Class cls) {
        return cls.getName().compareTo("java.sql.Date") == 0 || cls.getName().compareTo("java.sql.Time") == 0 || cls.getName().compareTo("java.sql.Timestamp") == 0 || cls.getName().compareTo("java.lang.String") == 0;
    }

    private static int setHighOrderbits(int ID) {
        return (ID & 0x1FC0) >> 6;
    }

    private static int setLowOrderbits(int ID) {
        return (ID & 0x3F) << 2;
    }

    private static int getHighOrderbits(int hour) {
        return (hour & 0x7F) << 6;
    }

    private static int getLowOrderbits(int minute) {
        return (minute & 0xFC) >> 2;
    }

    private static int getJavaYear(int cent, int decade) {
        return (cent - 100) * 100 + (decade - 100);
    }

    static TIMEZONETAB getTIMEZONETAB(Connection conn) throws SQLException {
        OracleConnection oconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        return oconn.getTIMEZONETAB();
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.TIMESTAMPTZ"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

