/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2;

import com.qiyuesuo.sdk.v2.exception.ServiceException;
import com.qiyuesuo.sdk.v2.http.HttpClient;
import com.qiyuesuo.sdk.v2.http.HttpHeader;
import com.qiyuesuo.sdk.v2.http.HttpParameter;
import com.qiyuesuo.sdk.v2.request.SdkRequest;
import com.qiyuesuo.sdk.v2.utils.MD5;
import com.qiyuesuo.sdk.v2.utils.StringUtils;
import java.io.OutputStream;
import java.util.UUID;

public class SaaSSdkClient {
    public static final String SDK_VERSION = "JAVA-3.1.7";
    private String agentAccessKey;
    private String agentAccessSecret;
    private String accessKey;
    private String accessSecret;
    private String serverUrl;
    private int connectTimeout = 15000;
    private int readTimeout = 60000;

    public SaaSSdkClient(String agentKey, String agentSecret, String serverUrl) {
        this.agentAccessKey = agentKey;
        this.agentAccessSecret = agentSecret;
        this.serverUrl = serverUrl;
    }

    public SaaSSdkClient(String agentKey, String agentSecret, String serverUrl, int connectTimeout, int readTimeout) {
        this(agentKey, agentSecret, serverUrl);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public SaaSSdkClient(String agentKey, String agentSecret, String key, String secret, String serverUrl) {
        this.agentAccessKey = agentKey;
        this.agentAccessSecret = agentSecret;
        this.accessKey = key;
        this.accessSecret = secret;
        this.serverUrl = serverUrl;
    }

    public SaaSSdkClient(String agentKey, String agentSecret, String appKey, String appSecret, String serverUrl, int connectTimeout, int readTimeout) {
        this(agentKey, agentSecret, appKey, appSecret, serverUrl);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public String service(SdkRequest request) throws ServiceException {
        String url = this.serverUrl + request.getUrl();
        Long timestamp = System.currentTimeMillis();
        String signature = null;
        String nonce = null;
        if (StringUtils.isNotBlank(this.accessKey)) {
            nonce = UUID.randomUUID().toString();
            signature = MD5.toMD5(this.accessKey + this.accessSecret + Long.toString(timestamp) + nonce);
        }
        String agentSignature = MD5.toMD5(this.agentAccessKey + this.agentAccessSecret + Long.toString(timestamp));
        HttpHeader header = new HttpHeader(this.accessKey, this.agentAccessKey, timestamp, signature, agentSignature, SDK_VERSION, nonce);
        HttpParameter httpParameter = request.getHttpParameter();
        try {
            if (httpParameter.isJson()) {
                return HttpClient.doServiceWithJson(url, httpParameter.getJsonParams(), header, this.connectTimeout, this.readTimeout);
            }
            return HttpClient.doService(url, httpParameter, header, this.connectTimeout, this.readTimeout);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public void download(SdkRequest request, OutputStream outputStream) throws ServiceException {
        String url = this.serverUrl + request.getUrl();
        Long timestamp = System.currentTimeMillis();
        String signature = null;
        String nonce = null;
        if (StringUtils.isNotBlank(this.accessKey)) {
            nonce = UUID.randomUUID().toString();
            signature = MD5.toMD5(this.accessKey + this.accessSecret + Long.toString(timestamp) + nonce);
        }
        String agentSignature = MD5.toMD5(this.agentAccessKey + this.agentAccessSecret + Long.toString(timestamp));
        HttpHeader header = new HttpHeader(this.accessKey, this.agentAccessKey, timestamp, signature, agentSignature, SDK_VERSION, nonce);
        try {
            HttpClient.doDownload(url, request.getHttpParameter(), header, this.connectTimeout, this.readTimeout, outputStream);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }
}

