/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.request;

import com.qiyuesuo.sdk.v2.http.HttpParameter;
import com.qiyuesuo.sdk.v2.param.ParamSwitcher;
import com.qiyuesuo.sdk.v2.request.SdkRequest;
import com.qiyuesuo.sdk.v2.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class ContractDownloadRequest
implements SdkRequest {
    private final String REQUEST_URL = "/v2/contract/download";
    private Long contractId;
    private String bizId;
    private String tenantName;
    private List<String> downloadItems;

    public ContractDownloadRequest(Long contractId) {
        this.contractId = contractId;
    }

    public ContractDownloadRequest(String bizId) {
        this.bizId = bizId;
    }

    public ContractDownloadRequest(String bizId, String tenantName) {
        this.bizId = bizId;
        this.tenantName = tenantName;
    }

    @Override
    public String getUrl() {
        return "/v2/contract/download";
    }

    @Override
    public HttpParameter getHttpParameter() {
        ParamSwitcher switcher = ParamSwitcher.newInstance("contractId", this.contractId).add("bizId", this.bizId).add("tenantName", this.tenantName).add("downloadItems", this.getItemString());
        HttpParameter parameter = HttpParameter.httpGetParamer();
        parameter.setParams(switcher);
        return parameter;
    }

    public List<String> getDownloadItems() {
        return this.downloadItems;
    }

    public void setDownloadItems(List<String> downloadItems) {
        this.downloadItems = downloadItems;
    }

    public List<String> addDownloadItem(String item) {
        if (this.downloadItems == null) {
            this.downloadItems = new ArrayList<String>();
        }
        this.downloadItems.add(item);
        return this.downloadItems;
    }

    public String getItemString() {
        if (CollectionUtils.isEmpty(this.downloadItems)) {
            return null;
        }
        return String.join((CharSequence)",", this.downloadItems);
    }
}

