/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.common.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.HttpConnection;
import net.qiyuesuo.sdk.common.http.HttpHeader;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.utils.ArrayUtils;
import net.qiyuesuo.sdk.common.utils.IOUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class HttpClient {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String CONTENT_FORM = "application/x-www-form-urlencoded;charset=UTF-8";
    public static final String APPLICATION_JSON = "application/json";
    public static final String CONTENT_MULTIPART = "multipart/form-data;charset=UTF-8; boundary=";
    public static final int RENNECT_TIMES = 0;

    public static String doService(String url, HttpParamers paramers, HttpHeader header, int connectTimeout, int readTimeout) throws Exception {
        HttpMethod httpMethod = paramers.getHttpMethod();
        switch (httpMethod) {
            case POST: {
                return HttpClient.doPost(url, paramers, header, connectTimeout, readTimeout);
            }
            case GET: {
                return HttpClient.doGet(url, paramers, header, connectTimeout, readTimeout);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doServiceWithJson(String url, String json, HttpHeader header, int connectTimeout, int readTimeout) throws Exception {
        String string;
        HttpURLConnection conn = null;
        OutputStream out = null;
        byte[] content = null;
        for (int i = 0; i <= 0; ++i) {
            try {
                conn = HttpConnection.getConnection(new URL(url), HttpMethod.POST, header);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                content = json == null ? ArrayUtils.EMPTY_BYTE_ARRAY : json.getBytes(DEFAULT_CHARSET);
                conn.setRequestProperty("Content-Type", APPLICATION_JSON);
                out = conn.getOutputStream();
                break;
            }
            catch (Exception e) {
                IOUtils.safeClose(out);
                HttpConnection.close(conn);
                if (i != 0) continue;
                throw e;
            }
        }
        try {
            out.write(content);
            string = HttpClient.getResponseAsString(conn);
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(out);
            HttpConnection.close(conn);
            throw throwable;
        }
        IOUtils.safeClose(out);
        HttpConnection.close(conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, HttpParamers paramers, HttpHeader header, int connectTimeout, int readTimeout) throws Exception {
        String string;
        HttpURLConnection conn = null;
        OutputStream out = null;
        String boundary = null;
        byte[] content = null;
        for (int i = 0; i <= 0; ++i) {
            try {
                conn = HttpConnection.getConnection(new URL(url), HttpMethod.POST, header);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                if (paramers.isMultipart()) {
                    boundary = "----sdkboundary" + StringUtils.random(6);
                    conn.setRequestProperty("Content-Type", CONTENT_MULTIPART + boundary);
                    out = conn.getOutputStream();
                    break;
                }
                String query = paramers.getQueryString(DEFAULT_CHARSET);
                content = query == null ? ArrayUtils.EMPTY_BYTE_ARRAY : query.getBytes(DEFAULT_CHARSET);
                conn.setRequestProperty("Content-Type", CONTENT_FORM);
                out = conn.getOutputStream();
                break;
            }
            catch (Exception e) {
                IOUtils.safeClose(out);
                HttpConnection.close(conn);
                if (i != 0) continue;
                throw e;
            }
        }
        try {
            if (paramers.isMultipart()) {
                HttpClient.writeMutiContent(boundary, paramers, out);
            } else {
                out.write(content);
            }
            string = HttpClient.getResponseAsString(conn);
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(out);
            HttpConnection.close(conn);
            throw throwable;
        }
        IOUtils.safeClose(out);
        HttpConnection.close(conn);
        return string;
    }

    protected static void writeMutiContent(String boundary, HttpParamers paramers, OutputStream out) throws IOException {
        byte[] boundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(DEFAULT_CHARSET);
        Set<Map.Entry<String, String>> textEntrySet = paramers.getParams().entrySet();
        boolean firstParam = true;
        for (Map.Entry<String, String> textEntry : textEntrySet) {
            byte[] byArray = HttpClient.getTextEntry(textEntry.getKey(), textEntry.getValue(), DEFAULT_CHARSET);
            if (firstParam) {
                out.write(("--" + boundary + "\r\n").getBytes(DEFAULT_CHARSET));
                firstParam = false;
            } else {
                out.write(boundaryBytes);
            }
            out.write(byArray);
        }
        if (!paramers.getFiles().isEmpty()) {
            Set<Map.Entry<String, FileItem>> fileEntrySet = paramers.getFiles().entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                FileItem fileItem = entry.getValue();
                if (!fileItem.isValid()) {
                    throw new IOException("FileItem is invalid");
                }
                byte[] fileBytes = HttpClient.getFileEntry(entry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), DEFAULT_CHARSET);
                out.write(boundaryBytes);
                out.write(fileBytes);
                fileItem.write(out);
            }
        }
        if (!paramers.getListFiles().isEmpty()) {
            Set<Map.Entry<String, List<FileItem>>> listEntrySet = paramers.getListFiles().entrySet();
            for (Map.Entry<String, Object> entry : listEntrySet) {
                List items = (List)entry.getValue();
                for (FileItem item : items) {
                    if (!item.isValid()) {
                        throw new IOException("FileItem is invalid");
                    }
                    byte[] fileBytes = HttpClient.getFileEntry(entry.getKey(), item.getFileName(), item.getMimeType(), DEFAULT_CHARSET);
                    out.write(boundaryBytes);
                    out.write(fileBytes);
                    item.write(out);
                }
            }
        }
        byte[] endBoundary = ("\r\n--" + boundary + "--\r\n").getBytes(DEFAULT_CHARSET);
        out.write(endBoundary);
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, HttpParamers params, HttpHeader header, int connectTimeout, int readTimeout) throws Exception {
        String string;
        HttpURLConnection conn = null;
        String query = params.getQueryString(DEFAULT_CHARSET);
        URL getUrl = HttpClient.buildGetUrl(url, query);
        int responseCode = 200;
        for (int i = 0; i <= 0; ++i) {
            try {
                conn = HttpConnection.getConnection(getUrl, HttpMethod.GET, header);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                responseCode = conn.getResponseCode();
                break;
            }
            catch (Exception e) {
                HttpConnection.close(conn);
                if (i != 0) continue;
                throw e;
            }
        }
        try {
            string = HttpClient.getResponseAsString(conn, responseCode);
        }
        catch (Throwable throwable) {
            HttpConnection.close(conn);
            throw throwable;
        }
        HttpConnection.close(conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDownload(String url, HttpParamers params, HttpHeader header, int connectTimeout, int readTimeout, OutputStream outputStream) throws Exception {
        HttpURLConnection conn = null;
        String query = params.getQueryString(DEFAULT_CHARSET);
        URL getUrl = HttpClient.buildGetUrl(url, query);
        int responseCode = 200;
        for (int i = 0; i <= 0; ++i) {
            try {
                conn = HttpConnection.getConnection(getUrl, HttpMethod.GET, header);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                responseCode = conn.getResponseCode();
                break;
            }
            catch (Exception e) {
                HttpConnection.close(conn);
                if (i != 0) continue;
                throw e;
            }
        }
        try {
            HttpClient.getResponseAsOutputStream(conn, outputStream, responseCode);
        }
        catch (Throwable throwable) {
            HttpConnection.close(conn);
            throw throwable;
        }
        HttpConnection.close(conn);
    }

    protected static URL buildGetUrl(String url, String query) throws IOException {
        boolean hasPrepend;
        if (StringUtils.isEmpty(query)) {
            return new URL(url);
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean bl = hasPrepend = url.endsWith("?") || url.endsWith("&");
        if (!hasPrepend) {
            if (hasQuery) {
                newUrl.append("&");
            } else {
                newUrl.append("?");
                hasQuery = true;
            }
        }
        newUrl.append(query);
        hasPrepend = false;
        return new URL(newUrl.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getResponseAsString(HttpURLConnection conn, int responseCode) throws IOException {
        String charset = HttpClient.getResponseCharset(conn.getContentType());
        if (responseCode < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                return HttpClient.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return HttpClient.getStreamAsString(conn.getInputStream(), charset);
        }
        String errorStr = "";
        InputStream inputStream = conn.getErrorStream();
        try {
            byte[] bs;
            if (inputStream != null && (bs = new byte[inputStream.available()]).length > 0) {
                inputStream.read(bs);
                errorStr = new String(bs, DEFAULT_CHARSET);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage() + " " + errorStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = HttpClient.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                return HttpClient.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return HttpClient.getStreamAsString(conn.getInputStream(), charset);
        }
        String errorStr = "";
        InputStream inputStream = conn.getErrorStream();
        try {
            byte[] bs;
            if (inputStream != null && (bs = new byte[inputStream.available()]).length > 0) {
                inputStream.read(bs);
                errorStr = new String(bs, DEFAULT_CHARSET);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage() + " " + errorStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getResponseAsOutputStream(HttpURLConnection conn, OutputStream outputStream, int responseCode) throws IOException {
        if (responseCode >= 400) {
            String errorStr = "";
            InputStream inputStream = conn.getErrorStream();
            try {
                byte[] bs;
                if (inputStream != null && (bs = new byte[inputStream.available()]).length > 0) {
                    inputStream.read(bs);
                    errorStr = new String(bs, DEFAULT_CHARSET);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage() + " " + errorStr);
        }
        outputStream.write(IOUtils.readStreamAsByteArray(conn.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }
}

