/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.CompanyService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.company.CompanyAuth;
import net.qiyuesuo.sdk.bean.company.CompanyAuthNoticeRequset;
import net.qiyuesuo.sdk.bean.company.CompanyAuthPage;
import net.qiyuesuo.sdk.bean.company.CompanyCredit;
import net.qiyuesuo.sdk.bean.company.CompanyRequest;
import net.qiyuesuo.sdk.bean.company.CreateCompanyRequest;
import net.qiyuesuo.sdk.bean.company.TenantStatus;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.sealapply.MapUtil;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class CompanyServiceImpl
implements CompanyService {
    private SDKClient client;

    public CompanyServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String createCompany(CreateCompanyRequest request) throws Exception {
        Map<String, Object> result;
        Integer code;
        request.valid();
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("legalPerson", request.getLegalPerson());
        paramers.addParam("legalPersonId", request.getLegalPersonId());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("operator", request.getOperator());
        paramers.addParam("paperType", request.getPaperType());
        paramers.addParam("province", request.getProvince());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("tenantType", request.getTenantType().name());
        if (request.getRemind() != null) {
            paramers.addParam("remind", String.valueOf(request.getRemind()));
        }
        if ((code = (Integer)(result = this.client.doService("/company/create", paramers)).get("code")) != 0) {
            throw new Exception("\u521b\u5efa\u4f01\u4e1a\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Company company = null;
        Map companyMap = (Map)result.get("result");
        try {
            company = MapUtils.toObject(companyMap, Company.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return company == null ? null : company.getOpenCompanyId();
    }

    @Override
    public Company create(CreateCompanyRequest request) throws Exception {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("legalPerson", request.getLegalPerson());
        paramers.addParam("legalPersonId", request.getLegalPersonId());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("operator", request.getOperator());
        paramers.addParam("paperType", request.getPaperType());
        paramers.addParam("province", request.getProvince());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("tenantType", request.getTenantType().name());
        if (request.getCompanyType() != null) {
            paramers.addParam("companyType", "" + request.getCompanyType());
        }
        if (request.getRemind() != null) {
            paramers.addParam("remind", String.valueOf(request.getRemind()));
        }
        paramers.addParam("area", request.getArea());
        Map<String, Object> result = this.client.doService("/company/create", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u4f01\u4e1a\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Company company = null;
        Map companyMap = (Map)result.get("result");
        try {
            company = MapUtils.toObject(companyMap, Company.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return company;
    }

    @Override
    public String getComnpanyAuthStatus(String companyName) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("companyName", companyName);
        Map<String, Object> result = this.client.doService("/company/status", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u72b6\u6001\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("result");
    }

    @Override
    public List<Company> queryList(TenantType tenantType) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (tenantType != null) {
            paramers.addParam("tenantType", tenantType.toString());
        }
        if ((code = (Integer)(result = this.client.doService("/company/list", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u516c\u53f8\u5217\u8868\u5931\u8d25," + (String)result.get("message"));
        }
        ArrayList<Company> companies = new ArrayList<Company>();
        if (result.get("result") != null) {
            List companyList = (List)result.get("result");
            for (Map companyMap : companyList) {
                Company company = new Company();
                company.setId(Long.valueOf((String)companyMap.get("id")));
                company.setName((String)companyMap.get("name"));
                if (companyMap.get("status") != null) {
                    company.setStatus(TenantStatus.valueOf((String)companyMap.get("status")));
                }
                if (companyMap.get("tenantType") != null) {
                    company.setTenantType(TenantType.valueOf((String)companyMap.get("tenantType")));
                }
                if (companyMap.get("parentId") != null) {
                    company.setParentId(Long.valueOf((String)companyMap.get("parentId")));
                }
                companies.add(company);
            }
        }
        return companies;
    }

    @Override
    public Company detail(CompanyRequest request) throws Exception {
        Map<String, Object> result;
        Integer code;
        if (request == null) {
            return null;
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        if (StringUtils.isNotBlank(request.getCompanyName())) {
            paramers.addParam("companyName", request.getCompanyName());
        }
        if (StringUtils.isNotBlank(request.getRegisterNo())) {
            paramers.addParam("registerNo", request.getRegisterNo());
        }
        if ((code = (Integer)(result = this.client.doService("/company/detail", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u516c\u53f8\u8be6\u60c5\u5931\u8d25," + (String)result.get("message"));
        }
        Map companyMap = (Map)result.get("result");
        Company company = new Company();
        if (companyMap != null) {
            company.setId(MapUtil.getLong(companyMap, "id"));
            company.setName(MapUtil.getString(companyMap, "name"));
            company.setRegisterNo(MapUtil.getString(companyMap, "registerNo"));
            company.setTenantType(TenantType.valueOf(MapUtil.getString(companyMap, "tenantType")));
            company.setCreateTime(MapUtil.getDate(companyMap, "createTime"));
            company.setStatus(TenantStatus.valueOf(MapUtil.getString(companyMap, "status")));
            company.setLegalPerson(MapUtil.getString(companyMap, "legalPerson"));
            company.setLegalPersonId(MapUtil.getString(companyMap, "legalPersonId"));
            company.setParentId(MapUtil.getLong(companyMap, "parentId"));
            company.setFreeze(MapUtil.getBoolean(companyMap, "freeze"));
        }
        return company;
    }

    @Override
    public void sendCompanyAuthNotice(CompanyAuthNoticeRequset request) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("legalPerson", request.getLegalPerson());
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        if ((code = (Integer)(result = this.client.doService("/companyauth/notice", paramers)).get("code")) != 0) {
            throw new Exception("\u521b\u5efa\u5e76\u53d1\u9001\u5916\u90e8\u516c\u53f8\u4f01\u4e1a\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25," + (String)result.get("message"));
        }
    }

    @Override
    public Company sendCompanyAuthNotify(CompanyAuthNoticeRequset request) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("legalPerson", request.getLegalPerson());
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        if ((code = (Integer)(result = this.client.doService("/companyauth/notice", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u521b\u5efa\u5e76\u53d1\u9001\u5916\u90e8\u516c\u53f8\u4f01\u4e1a\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25," + (String)result.get("message"));
        }
        Long companyId = MapUtil.getLong((Map)result.get("result"), "id");
        Company company = new Company();
        if (companyId != null) {
            company.setId(companyId);
        }
        return company;
    }

    @Override
    public void changeInfo(CompanyAuth companyAuth) throws PrivateAppException {
        throw new PrivateAppException("\u8bf7\u4f7f\u7528\u65b0\u7248\u4f01\u4e1a\u4fe1\u606f\u53d8\u66f4\u63a5\u53e3");
    }

    @Override
    public String changeInfo(CompanyRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", request.getCompanyId().toString());
        }
        paramers.addParam("companyName", request.getCompanyName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("h5", String.valueOf(request.getH5()));
        Map<String, Object> result = this.client.doService("/company/changeinfo", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u53d8\u66f4\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25," + (String)result.get("message"));
        }
        return (String)result.get("authUrl");
    }

    @Override
    public void deleteUnceritifiedCompany(CompanyRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        paramers.addParam("companyName", request.getCompanyName());
        Map<String, Object> result = this.client.doService("/company/delete", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u5220\u9664\u672a\u8ba4\u8bc1\u4f01\u4e1a\u5931\u8d25," + (String)result.get("message"));
        }
    }

    @Override
    public void freezeOrUnfreezeCompany(CompanyRequest request, Boolean freeze) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        paramers.addParam("companyName", request.getCompanyName());
        Map<Object, Object> result = new HashMap();
        result = freeze != false ? this.client.doService("/company/freeze", paramers) : this.client.doService("/company/unfreeze", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u51bb\u7ed3\u4f01\u4e1a\u5931\u8d25," + (String)result.get("message"));
        }
    }

    @Override
    public CompanyCredit manageStatus(CompanyRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        paramers.addParam("companyName", request.getCompanyName());
        paramers.addParam("registerNo", request.getRegisterNo());
        Map<String, Object> result = this.client.doService("/company/managestatus", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u67e5\u8be2\u4f01\u4e1a\u7ecf\u8425\u72b6\u6001\u4fe1\u606f\u5931\u8d25," + (String)result.get("message"));
        }
        Map companyCreditMap = (Map)result.get("result");
        CompanyCredit companyCredit = null;
        try {
            companyCredit = MapUtils.toObject(companyCreditMap, CompanyCredit.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return companyCredit;
    }

    @Override
    public String companyAuthPCPage(CompanyAuthPage request) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        if (request.getLegalPerson() != null) {
            paramers.addParam("legalPerson", request.getLegalPerson());
        }
        if ((code = (Integer)(result = this.client.doService("/companyauth/pcpage", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u94fe\u63a5\u5931\u8d25," + (String)result.get("message"));
        }
        String authurl = (String)result.get("authurl");
        return authurl;
    }

    @Override
    public String companyAuthH5Page(CompanyAuthPage request) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        if (request.getLegalPerson() != null) {
            paramers.addParam("legalPerson", request.getLegalPerson());
        }
        if ((code = (Integer)(result = this.client.doService("/companyauth/h5page", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u94fe\u63a5\u5931\u8d25," + (String)result.get("message"));
        }
        String authurl = (String)result.get("authurl");
        return authurl;
    }
}

