/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.DataSignService;
import net.qiyuesuo.sdk.bean.datasign.DataSignBean;
import net.qiyuesuo.sdk.bean.datasign.DataSignRequest;
import net.qiyuesuo.sdk.bean.datasign.DataSignSignatory;
import net.qiyuesuo.sdk.bean.sign.QueryDataRequest;
import net.qiyuesuo.sdk.bean.sign.VerifyResult;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class DataSignServiceImpl
implements DataSignService {
    private SDKClient client;

    public DataSignServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String sign(InputStream data, String bizId, String user, String cardNo, String contact) throws Exception {
        if (data == null) {
            throw new Exception("data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new Exception("bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(data);
        paramers.addFile("file", fileItem);
        paramers.addParam("businessId", bizId);
        paramers.addParam("userName", user);
        if (StringUtils.isNotBlank(cardNo)) {
            paramers.addParam("cardNo", cardNo);
        }
        paramers.addParam("contact", contact);
        Map<String, Object> result = this.client.doService("/datasign/sign", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u540d\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("result");
    }

    @Override
    public String viewUrl(String bizId) throws Exception {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new Exception("bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/viewurl", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u540d\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("viewUrl");
    }

    @Override
    public String getSrcData(String bizId) throws Exception {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new Exception("bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/getsrcdata", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        return (String)result.get("data");
    }

    @Override
    public VerifyResult getSrcAndCert(String bizId) throws Exception {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new Exception("bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/getsrcandcert", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        Map verifyMap = (Map)result.get("verifyinfo");
        VerifyResult verifyinfo = new VerifyResult();
        verifyinfo.setCertDateFrom((String)verifyMap.get("certDateFrom"));
        verifyinfo.setCertDateTo((String)verifyMap.get("certDateTo"));
        verifyinfo.setCode(code);
        verifyinfo.setMsg((String)verifyMap.get("msg"));
        verifyinfo.setOrganization((String)verifyMap.get("organization"));
        verifyinfo.setSerialNumber((String)verifyMap.get("serialNumber"));
        verifyinfo.setSignatory((String)verifyMap.get("signatory"));
        verifyinfo.setSignDate((String)verifyMap.get("signDate"));
        verifyinfo.setSignResult((String)verifyMap.get("signResult"));
        verifyinfo.setSignTime((String)verifyMap.get("signTime"));
        verifyinfo.setSrcDate((String)verifyMap.get("srcDate"));
        verifyinfo.setStrAlgName((String)verifyMap.get("strAlgName"));
        return verifyinfo;
    }

    @Override
    public VerifyResult getSrcAndCert(QueryDataRequest queryDataRequest) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", queryDataRequest.getBizId());
        if (queryDataRequest.getSensitiveInfoInvisible() != null) {
            paramers.addParam("sensitiveInfoInvisible", String.valueOf(queryDataRequest.getSensitiveInfoInvisible()));
        }
        if ((code = (Integer)(result = this.client.doService("/datasign/getsrcandcert", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        Map verifyMap = (Map)result.get("verifyinfo");
        VerifyResult verifyinfo = new VerifyResult(verifyMap);
        verifyinfo.setCode(code);
        return verifyinfo;
    }

    @Override
    public Long sign(DataSignBean dataSignBean) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addFile("data", dataSignBean.getData());
        paramers.addParam("dataType", dataSignBean.getDataType());
        if (dataSignBean.getSignatory() != null) {
            paramers.addParam("signatory", JSONUtils.toJson(dataSignBean.getSignatory()));
        }
        paramers.addParam("businessData", dataSignBean.getBusinessData());
        Map<String, Object> result = this.client.doService("/binary/sign", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u6570\u636e\u7b7e\u540d\u7b7e\u7f72\u5931\u8d25");
        }
        return Long.valueOf(String.valueOf(result.get("id")));
    }

    @Override
    public DataSignSignatory detail(DataSignRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getId() != null) {
            paramers.addParam("id", request.getId().toString());
        }
        paramers.addParam("bizId", request.getBizId());
        Map<String, Object> result = this.client.doService("/binary/detail", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u6570\u636e\u7b7e\u540d\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        Map dataSignSignatoryMap = (Map)result.get("result");
        DataSignSignatory dataSignSignatory = null;
        try {
            dataSignSignatory = MapUtils.toObject(dataSignSignatoryMap, DataSignSignatory.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return dataSignSignatory;
    }

    @Override
    public void download(DataSignRequest request, OutputStream outputStream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getId() != null) {
            paramers.addParam("id", request.getId().toString());
        }
        paramers.addParam("bizId", request.getBizId());
        this.client.download("/binary/download", paramers, outputStream);
    }

    @Override
    public String signUrl(DataSignBean request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addFile("data", request.getData());
        paramers.addParam("dataType", request.getDataType());
        if (request.getSignatory() != null) {
            paramers.addParam("signatory", JSONUtils.toJson(request.getSignatory()));
        }
        paramers.addParam("businessData", request.getBusinessData());
        paramers.addParam("oaUrl", request.getOaUrl());
        Map<String, Object> result = this.client.doService("/binary/signurl", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u6570\u636e\u7b7e\u540d\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25");
        }
        return String.valueOf(result.get("signUrl"));
    }
}

