/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.EmployeeService;
import net.qiyuesuo.sdk.bean.employee.InnerEmployeeRequest;
import net.qiyuesuo.sdk.bean.employee.RemoveEmployeeRequest;
import net.qiyuesuo.sdk.bean.employee.UserBean;
import net.qiyuesuo.sdk.bean.employee.UserSearchRequest;
import net.qiyuesuo.sdk.bean.role.Role;
import net.qiyuesuo.sdk.bean.user.UserAuthStatus;
import net.qiyuesuo.sdk.bean.user.UserDetail;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;

public class EmployeeServiceImpl
implements EmployeeService {
    private SDKClient client;

    public EmployeeServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String createInnerCompanyEmployee(InnerEmployeeRequest request) throws Exception {
        request.valid();
        Map<String, Object> result = this.client.doServiceWithJson("/employee/create", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u5185\u90e8\u4f01\u4e1a\u5458\u5de5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("result");
    }

    @Override
    public void quit(RemoveEmployeeRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contact", request.getContact());
        paramers.addParam("employeeNo", request.getEmployeeNo());
        paramers.addParam("openUserId", request.getOpenUserId());
        paramers.addParam("companyName", request.getCompanyName());
        Map<String, Object> result = this.client.doService("/company/removeemployee", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException(code, "\u79fb\u9664\u5458\u5de5\u5931\u8d25," + (String)result.get("message"));
        }
    }

    @Override
    public void quitInnerCompanyEmployee(RemoveEmployeeRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contact", request.getContact());
        paramers.addParam("employeeNo", request.getEmployeeNo());
        paramers.addParam("openUserId", request.getOpenUserId());
        paramers.addParam("companyName", request.getCompanyName());
        Map<String, Object> result = this.client.doService("/company/removeinneremployees", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException(code, "\u79fb\u9664\u5185\u90e8\u4f01\u4e1a\u5458\u5de5\u5931\u8d25," + (String)result.get("message"));
        }
    }

    @Override
    public UserDetail userDetail(UserSearchRequest request) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("cardNo", request.getCardNo());
        paramers.addParam("number", request.getNumber());
        if (request.getId() != null) {
            paramers.addParam("id", String.valueOf(request.getId()));
        }
        if ((code = (Integer)(result = this.client.doService("/user", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map authResult = (Map)result.get("result");
        UserDetail userInfo = new UserDetail();
        if (authResult.get("id") != null) {
            userInfo.setId(Long.valueOf((String)authResult.get("id")));
        }
        userInfo.setName((String)authResult.get("name"));
        userInfo.setCardNo((String)authResult.get("cardNo"));
        userInfo.setMobile((String)authResult.get("mobile"));
        userInfo.setStatus(UserAuthStatus.valueOf((String)authResult.get("status")));
        userInfo.setCompanies((List)authResult.get("companies"));
        return userInfo;
    }

    @Override
    public List<Role> listByRoleType(Role request) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        if (request.getCompanyName() != null) {
            paramers.addParam("companyName", request.getCompanyName());
        }
        if (request.getRoleType() != null) {
            paramers.addParam("roleType", request.getRoleType().name());
        }
        if ((code = (Integer)(result = this.client.doService("/rolelist", paramers)).get("code")) != 0) {
            throw new PrivateAppException(code, "\u6839\u636e\u89d2\u8272\u7c7b\u578b\u67e5\u8be2\u5458\u5de5\u5931\u8d25," + (String)result.get("message"));
        }
        List<Role> roles = new ArrayList<Role>();
        List roleMaps = (List)result.get("result");
        if (roleMaps != null) {
            try {
                roles = MapUtils.toObjectList(roleMaps, Role.class);
            }
            catch (Exception e) {
                throw new PrivateAppException("\u6839\u636e\u89d2\u8272\u7c7b\u578b\u67e5\u8be2\u5458\u5de5,\u7ed3\u679c\u8f6c\u6362\u5931\u8d25 ", e);
            }
        }
        return roles;
    }

    @Override
    public void authNotify(UserBean userBean) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/userauth/notice", JSONUtils.toJson(userBean));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException(code, "\u4e2a\u4eba\u8ba4\u8bc1\u77ed\u4fe1\u901a\u77e5\u5931\u8d25," + (String)result.get("message"));
        }
    }
}

