/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.FormSignatoryService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.form.CertInfo;
import net.qiyuesuo.sdk.bean.form.FormBean;
import net.qiyuesuo.sdk.bean.form.FormSignUrlBean;
import net.qiyuesuo.sdk.bean.formSignatory.FormSignatoryDeleteRequest;
import net.qiyuesuo.sdk.bean.formSignatory.FormSignatorySearchRequest;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.seal.SealType;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.CollectionUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class FormSignatoryServiceImpl
implements FormSignatoryService {
    private SDKClient client;

    public FormSignatoryServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public Long sign(FormBean formBean) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/formSignatory/sign", JSONUtils.toJson(formBean));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u8868\u5355\u7b7e\u7f72\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map map = (Map)result.get("result");
        Long bizId = Long.valueOf((String)map.get("id"));
        return bizId;
    }

    @Override
    public String signUrl(FormSignUrlBean formSignUrlBean) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/formSignatory/signurl", JSONUtils.toJson(formSignUrlBean));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u8868\u5355\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        String signurl = (String)result.get("signUrl");
        return signurl;
    }

    @Override
    public List<FormBean> get(String uuid) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("uuid", String.valueOf(uuid));
        Map<String, Object> result = this.client.doService("/formSignatory/get", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u8868\u5355\u7b7e\u7f72\u4fe1\u606f\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return this.parseFormBean(result);
    }

    @Override
    public List<FormBean> getByMobile(FormSignatorySearchRequest request) throws Exception {
        Map<String, Object> result;
        Integer code;
        request.valid();
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("uuid", request.getUuid());
        if (StringUtils.isNotBlank(request.getNodeId())) {
            paramers.addParam("nodeId", request.getNodeId());
        }
        if (StringUtils.isNotBlank(request.getMobile())) {
            paramers.addParam("mobile", request.getMobile());
        }
        if ((code = (Integer)(result = this.client.doService("/formSignatory/get", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u8868\u5355\u7b7e\u7f72\u4fe1\u606f\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return this.parseFormBean(result);
    }

    private List<FormBean> parseFormBean(Map<String, Object> result) throws ParseException {
        ArrayList<FormBean> results = new ArrayList<FormBean>();
        List formBeans = (List)result.get("result");
        if (CollectionUtils.isNotEmpty(formBeans)) {
            for (Map object : formBeans) {
                FormBean formBean = new FormBean();
                formBean.setId(Long.valueOf((String)object.get("id")));
                formBean.setUuid((String)object.get("uuid"));
                formBean.setNodeId(object.get("nodeId") == null ? null : (String)object.get("nodeId"));
                formBean.setSealId(Long.valueOf((String)object.get("sealId")));
                formBean.setY((Double)object.get("y"));
                formBean.setX((Double)object.get("x"));
                formBean.setCreateTime(TimeUtils.parse((String)object.get("createTime")));
                formBean.setParentNode(object.get("parentNode") == null ? null : (String)object.get("parentNode"));
                formBean.setTenantId(Long.valueOf((String)object.get("tenantId")));
                formBean.setTenantType(TenantType.valueOf((String)object.get("tenantType")));
                results.add(formBean);
            }
        }
        return results;
    }

    @Override
    public CertInfo getCert(Long id) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("bizId", String.valueOf(id));
        Map<String, Object> result = this.client.doService("/formSignatory/getcert", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u8868\u5355\u7b7e\u7f72\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        CertInfo cert = new CertInfo();
        Map map = (Map)result.get("result");
        cert.setCardNo((String)map.get("cardNo"));
        cert.setCaType((String)map.get("caType"));
        cert.setEndTime(TimeUtils.parse((String)map.get("endTime")));
        cert.setExpectedUse((String)map.get("expectedUse"));
        cert.setLocation((String)map.get("location"));
        cert.setSeriNo((String)map.get("seriNo"));
        cert.setSignReason((String)map.get("signReason"));
        cert.setSignTime(TimeUtils.parse((String)map.get("signTime")));
        cert.setStartTime(TimeUtils.parse((String)map.get("startTime")));
        cert.setTenantName((String)map.get("tenantName"));
        cert.setLocation((String)map.get("location"));
        return cert;
    }

    @Override
    public List<Seal> getSeals(Long companyId, Long userId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("companyId", String.valueOf(companyId));
        paramers.addParam("userId", String.valueOf(userId));
        Map<String, Object> result = this.client.doService("/formSignatory/seals", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u5370\u7ae0\u5217\u8868\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        ArrayList<Seal> results = new ArrayList<Seal>();
        List formBeans = (List)result.get("result");
        if (CollectionUtils.isNotEmpty(formBeans)) {
            for (Map map : formBeans) {
                Seal seal = new Seal();
                seal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
                seal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
                seal.setName(String.valueOf(map.get("name")));
                seal.setOtherName(String.valueOf(map.get("otherName")));
                seal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
                seal.setSealKey(String.valueOf(map.get("sealKey")));
                seal.setSpec(String.valueOf(map.get("spec")));
                seal.setStatus(String.valueOf(map.get("status")));
                seal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
                results.add(seal);
            }
        }
        return results;
    }

    @Override
    public void delete(String uuid, String nodeId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("uuid", uuid);
        paramers.addParam("nodeId", nodeId);
        Map<String, Object> result = this.client.doService("/formSignatory/delete", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u50ac\u7b7e\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void batchDelete(FormSignatoryDeleteRequest request) throws Exception {
        request.valid();
        Map<String, Object> result = this.client.doServiceWithJson("/formSignatory/batchdelete", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u6279\u91cf\u5220\u9664\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }
}

