/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.TemplateService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.template.DocumentType;
import net.qiyuesuo.sdk.bean.template.MimeType;
import net.qiyuesuo.sdk.bean.template.ParamType;
import net.qiyuesuo.sdk.bean.template.Template;
import net.qiyuesuo.sdk.bean.template.TemplateGroup;
import net.qiyuesuo.sdk.bean.template.TemplateGroupRequest;
import net.qiyuesuo.sdk.bean.template.TemplateParam;
import net.qiyuesuo.sdk.bean.template.TemplateRequest;
import net.qiyuesuo.sdk.bean.template.TemplateTag;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class TemplateServiceImpl
implements TemplateService {
    private SDKClient client;

    public TemplateServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public List<Template> list(TemplateRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getTenantId() != null) {
            paramers.addParam("tenantId", String.valueOf(request.getTenantId()));
        }
        if (StringUtils.isNotBlank(request.getTenantName())) {
            paramers.addParam("tenantName", request.getTenantName());
        }
        if (request.getKeyword() != null) {
            paramers.addParam("keyword", request.getKeyword());
        }
        if (request.getStatus() != null) {
            paramers.addParam("status", String.valueOf(request.getStatus()));
        }
        if (request.getCreateTimeFrom() != null) {
            paramers.addParam("createTimeFrom", TimeUtils.format(request.getCreateTimeFrom()));
        }
        if (request.getCreateTimeTo() != null) {
            paramers.addParam("createTimeTo", TimeUtils.format(request.getCreateTimeTo()));
        }
        if (request.getCreateTimeOrder() != null) {
            paramers.addParam("createTimeOrder", request.getCreateTimeOrder());
        }
        if (request.getTitleOrder() != null) {
            paramers.addParam("titleOrder", request.getTitleOrder());
        }
        if (request.getType() != null) {
            paramers.addParam("type", request.getType());
        }
        if (request.getProperty() != null) {
            paramers.addParam("property", request.getProperty());
        }
        if (request.getTags() != null) {
            paramers.addParam("tags", request.getTags());
        }
        paramers.addParam("thumbable", String.valueOf(request.isThumbable()));
        paramers.addParam("pageSize", String.valueOf(2000));
        Map<String, Object> result = this.client.doService("/template/list", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u5217\u8868\uff0c" + (String)result.get("message"));
        }
        ArrayList<Template> newlist = new ArrayList<Template>();
        try {
            List list = (List)result.get("result");
            Template template = null;
            for (Map tmap : list) {
                template = new Template();
                template.setId(Long.valueOf((String)tmap.get("id")));
                template.setTenantId(tmap.get("tenantId") == null ? null : Long.valueOf((String)tmap.get("tenantId")));
                template.setTitle(String.valueOf(tmap.get("title")));
                template.setTemplateType(DocumentType.valueOf((String)tmap.get("templateType")));
                template.setFileKey(String.valueOf(tmap.get("fileKey")));
                template.setPdfKey(String.valueOf(tmap.get("pdfKey")));
                template.setType(MimeType.valueOf(String.valueOf(tmap.get("type"))));
                template.setStatus((Integer)tmap.get("status"));
                template.setCreateTime(TimeUtils.parse((String)tmap.get("createTime")));
                template.setUpdateTime(TimeUtils.parse((String)tmap.get("updateTime")));
                template.setCover(String.valueOf(tmap.get("cover")));
                template.setConfig(String.valueOf(tmap.get("config")));
                template.setAttribute(String.valueOf(tmap.get("attribute")));
                List list1 = (List)tmap.get("tags");
                ArrayList<TemplateTag> list2 = new ArrayList<TemplateTag>();
                for (LinkedHashMap linkedHashMap : list1) {
                    TemplateTag templateTag = new TemplateTag();
                    templateTag.setTenantId(linkedHashMap.get("tenantId") == null ? null : Long.valueOf((String)linkedHashMap.get("tenantId")));
                    templateTag.setTemplateId(linkedHashMap.get("templateId") == null ? null : Long.valueOf((String)linkedHashMap.get("templateId")));
                    templateTag.setUpdateTime(TimeUtils.parse((String)linkedHashMap.get("updateTime")));
                    list2.add(templateTag);
                }
                template.setTags(list2);
                List list3 = (List)tmap.get("params");
                ArrayList<TemplateParam> list4 = new ArrayList<TemplateParam>();
                for (LinkedHashMap linkedHashMap : list3) {
                    TemplateParam templateParam = new TemplateParam();
                    templateParam.setId(linkedHashMap.get("id") == null ? null : Long.valueOf((String)linkedHashMap.get("id")));
                    templateParam.setTemplateId(linkedHashMap.get("templateId") == null ? null : Long.valueOf((String)linkedHashMap.get("templateId")));
                    templateParam.setName((String)linkedHashMap.get("name"));
                    templateParam.setType(ParamType.valueOf((String)linkedHashMap.get("type")));
                    templateParam.setDescription((String)linkedHashMap.get("description"));
                    templateParam.setRequired((Boolean)linkedHashMap.get("required"));
                    templateParam.setPage((Integer)linkedHashMap.get("page"));
                    templateParam.setOffsetX((Double)linkedHashMap.get("offsetX"));
                    templateParam.setOffsetY((Double)linkedHashMap.get("offsetY"));
                    templateParam.setSignatory(linkedHashMap.get("signatory") == null ? null : Long.valueOf((String)linkedHashMap.get("signatory")));
                    list4.add(templateParam);
                }
                template.setParams(list4);
                newlist.add(template);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return newlist;
    }

    @Override
    public String viewUrl(Long templateId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("templateId", String.valueOf(templateId));
        Map<String, Object> result = this.client.doService("/template/viewurl", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        String viewUrl = (String)result.get("url");
        return viewUrl;
    }

    @Override
    public TemplateGroup templateGroup(TemplateGroupRequest request) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers params = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            params.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        if (StringUtils.isNotBlank(request.getCompanyName())) {
            params.addParam("companyName", request.getCompanyName());
        }
        if ((code = (Integer)(result = this.client.doService("/template/templategroup", params)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u5206\u7ec4\u5217\u8868\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map templateGroupMap = (Map)result.get("result");
        TemplateGroup templateGroup = null;
        try {
            templateGroup = MapUtils.toObject(templateGroupMap, TemplateGroup.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return templateGroup;
    }

    @Override
    public Template detail(Long templateId) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (templateId != null) {
            paramers.addParam("templateId", String.valueOf(templateId));
        }
        if ((code = (Integer)(result = this.client.doService("/template/detail", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u6a21\u677f\u8be6\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map templateMap = (Map)result.get("result");
        Template template = null;
        try {
            template = MapUtils.toObject(templateMap, Template.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return template;
    }

    @Override
    public List<Company> innercompanyTempalteGroup(TemplateGroupRequest request) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        Map<String, Object> result = this.client.doService("/template/templategroup/list", params);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u6240\u6709\u5185\u90e8\u4f01\u4e1a\u5206\u7ec4\u5217\u8868\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        List companiesMap = (List)result.get("result");
        ArrayList<Company> companies = new ArrayList();
        try {
            companies = MapUtils.toObjectList(companiesMap, Company.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return companies;
    }
}

