/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs;

import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.ElementsVisitor;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.JRDelegationVisitor;

public class CrosstabDeepVisitor
extends JRDelegationVisitor
implements ElementsVisitor {
    public CrosstabDeepVisitor(JRVisitor visitor) {
        super(visitor);
    }

    @Override
    public boolean visitDeepElements() {
        return true;
    }

    public void deepVisitCrosstab(JRCrosstab crosstab) {
        block6: {
            block5: {
                this.visitCrosstabCell(crosstab.getWhenNoDataCell());
                this.visitCrosstabCell(crosstab.getHeaderCell());
                JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
                for (int i = 0; i < rowGroups.length; ++i) {
                    JRCrosstabRowGroup rowGroup = rowGroups[i];
                    this.visitCrosstabCell(rowGroup.getHeader());
                    this.visitCrosstabCell(rowGroup.getTotalHeader());
                }
                JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
                for (int i = 0; i < columnGroups.length; ++i) {
                    JRCrosstabColumnGroup columnGroup = columnGroups[i];
                    this.visitCrosstabCell(columnGroup.getCrosstabHeader());
                    this.visitCrosstabCell(columnGroup.getHeader());
                    this.visitCrosstabCell(columnGroup.getTotalHeader());
                }
                if (!(crosstab instanceof JRDesignCrosstab)) break block5;
                List<JRCrosstabCell> cells = ((JRDesignCrosstab)crosstab).getCellsList();
                for (JRCrosstabCell cell : cells) {
                    this.visitCrosstabCell(cell.getContents());
                }
                break block6;
            }
            JRCrosstabCell[][] cells = crosstab.getCells();
            if (cells == null) break block6;
            HashSet<JRCellContents> cellContents = new HashSet<JRCellContents>();
            for (int i = 0; i < cells.length; ++i) {
                for (int j = 0; j < cells[i].length; ++j) {
                    JRCrosstabCell cell = cells[i][j];
                    if (cell == null || cell.getContents() == null || !cellContents.add(cell.getContents())) continue;
                    this.visitCrosstabCell(cell.getContents());
                }
            }
        }
    }

    protected void visitCrosstabCell(JRCellContents cell) {
        if (cell != null) {
            ElementsVisitorUtils.visitElements(this, cell.getChildren());
        }
    }
}

